package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnL2Vips invokes the dcdn.DescribeDcdnL2Vips API synchronously
func (client *Client) DescribeDcdnL2Vips(request *DescribeDcdnL2VipsRequest) (response *DescribeDcdnL2VipsResponse, err error) {
	response = CreateDescribeDcdnL2VipsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnL2VipsWithChan invokes the dcdn.DescribeDcdnL2Vips API asynchronously
func (client *Client) DescribeDcdnL2VipsWithChan(request *DescribeDcdnL2VipsRequest) (<-chan *DescribeDcdnL2VipsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnL2VipsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnL2Vips(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnL2VipsWithCallback invokes the dcdn.DescribeDcdnL2Vips API asynchronously
func (client *Client) DescribeDcdnL2VipsWithCallback(request *DescribeDcdnL2VipsRequest, callback func(response *DescribeDcdnL2VipsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnL2VipsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnL2Vips(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnL2VipsRequest is the request struct for api DescribeDcdnL2Vips
type DescribeDcdnL2VipsRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
}

// DescribeDcdnL2VipsResponse is the response struct for api DescribeDcdnL2Vips
type DescribeDcdnL2VipsResponse struct {
	*responses.BaseResponse
	DomainName string   `json:"DomainName" xml:"DomainName"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Vips       []string `json:"Vips" xml:"Vips"`
}

// CreateDescribeDcdnL2VipsRequest creates a request to invoke DescribeDcdnL2Vips API
func CreateDescribeDcdnL2VipsRequest() (request *DescribeDcdnL2VipsRequest) {
	request = &DescribeDcdnL2VipsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnL2Vips", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnL2VipsResponse creates a response to parse from DescribeDcdnL2Vips response
func CreateDescribeDcdnL2VipsResponse() (response *DescribeDcdnL2VipsResponse) {
	response = &DescribeDcdnL2VipsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
