package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDIJob invokes the dataworks_public.StartDIJob API synchronously
func (client *Client) StartDIJob(request *StartDIJobRequest) (response *StartDIJobResponse, err error) {
	response = CreateStartDIJobResponse()
	err = client.DoAction(request, response)
	return
}

// StartDIJobWithChan invokes the dataworks_public.StartDIJob API asynchronously
func (client *Client) StartDIJobWithChan(request *StartDIJobRequest) (<-chan *StartDIJobResponse, <-chan error) {
	responseChan := make(chan *StartDIJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDIJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDIJobWithCallback invokes the dataworks_public.StartDIJob API asynchronously
func (client *Client) StartDIJobWithCallback(request *StartDIJobRequest, callback func(response *StartDIJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDIJobResponse
		var err error
		defer close(result)
		response, err = client.StartDIJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDIJobRequest is the request struct for api StartDIJob
type StartDIJobRequest struct {
	*requests.RpcRequest
	ForceToRerun          requests.Boolean `position:"Body" name:"ForceToRerun"`
	DIJobId               requests.Integer `position:"Body" name:"DIJobId"`
	RealtimeStartSettings string           `position:"Body" name:"RealtimeStartSettings"`
}

// StartDIJobResponse is the response struct for api StartDIJob
type StartDIJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartDIJobRequest creates a request to invoke StartDIJob API
func CreateStartDIJobRequest() (request *StartDIJobRequest) {
	request = &StartDIJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "StartDIJob", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDIJobResponse creates a response to parse from StartDIJob response
func CreateStartDIJobResponse() (response *StartDIJobResponse) {
	response = &StartDIJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
