package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApprovalProcess invokes the csas.UpdateApprovalProcess API synchronously
func (client *Client) UpdateApprovalProcess(request *UpdateApprovalProcessRequest) (response *UpdateApprovalProcessResponse, err error) {
	response = CreateUpdateApprovalProcessResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApprovalProcessWithChan invokes the csas.UpdateApprovalProcess API asynchronously
func (client *Client) UpdateApprovalProcessWithChan(request *UpdateApprovalProcessRequest) (<-chan *UpdateApprovalProcessResponse, <-chan error) {
	responseChan := make(chan *UpdateApprovalProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApprovalProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApprovalProcessWithCallback invokes the csas.UpdateApprovalProcess API asynchronously
func (client *Client) UpdateApprovalProcessWithCallback(request *UpdateApprovalProcessRequest, callback func(response *UpdateApprovalProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApprovalProcessResponse
		var err error
		defer close(result)
		response, err = client.UpdateApprovalProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApprovalProcessRequest is the request struct for api UpdateApprovalProcess
type UpdateApprovalProcessRequest struct {
	*requests.RpcRequest
	ProcessNodes *[]*[]string                      `position:"Body" name:"ProcessNodes"  type:"Repeated"`
	MatchSchemas UpdateApprovalProcessMatchSchemas `position:"Body" name:"MatchSchemas"  type:"Struct"`
	Description  string                            `position:"Body" name:"Description"`
	SourceIp     string                            `position:"Query" name:"SourceIp"`
	ProcessName  string                            `position:"Body" name:"ProcessName"`
	ProcessId    string                            `position:"Body" name:"ProcessId"`
}

// UpdateApprovalProcessMatchSchemas is a repeated param struct in UpdateApprovalProcessRequest
type UpdateApprovalProcessMatchSchemas struct {
	DomainBlacklistSchemaId    string `name:"DomainBlacklistSchemaId"`
	SoftwareBlockSchemaId      string `name:"SoftwareBlockSchemaId"`
	PeripheralBlockSchemaId    string `name:"PeripheralBlockSchemaId"`
	DeviceRegistrationSchemaId string `name:"DeviceRegistrationSchemaId"`
	DlpSendSchemaId            string `name:"DlpSendSchemaId"`
	DomainWhitelistSchemaId    string `name:"DomainWhitelistSchemaId"`
	AppUninstallSchemaId       string `name:"AppUninstallSchemaId"`
}

// UpdateApprovalProcessResponse is the response struct for api UpdateApprovalProcess
type UpdateApprovalProcessResponse struct {
	*responses.BaseResponse
}

// CreateUpdateApprovalProcessRequest creates a request to invoke UpdateApprovalProcess API
func CreateUpdateApprovalProcessRequest() (request *UpdateApprovalProcessRequest) {
	request = &UpdateApprovalProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateApprovalProcess", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateApprovalProcessResponse creates a response to parse from UpdateApprovalProcess response
func CreateUpdateApprovalProcessResponse() (response *UpdateApprovalProcessResponse) {
	response = &UpdateApprovalProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
