package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeUserSession invokes the csas.RevokeUserSession API synchronously
func (client *Client) RevokeUserSession(request *RevokeUserSessionRequest) (response *RevokeUserSessionResponse, err error) {
	response = CreateRevokeUserSessionResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeUserSessionWithChan invokes the csas.RevokeUserSession API asynchronously
func (client *Client) RevokeUserSessionWithChan(request *RevokeUserSessionRequest) (<-chan *RevokeUserSessionResponse, <-chan error) {
	responseChan := make(chan *RevokeUserSessionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeUserSession(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeUserSessionWithCallback invokes the csas.RevokeUserSession API asynchronously
func (client *Client) RevokeUserSessionWithCallback(request *RevokeUserSessionRequest, callback func(response *RevokeUserSessionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeUserSessionResponse
		var err error
		defer close(result)
		response, err = client.RevokeUserSession(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeUserSessionRequest is the request struct for api RevokeUserSession
type RevokeUserSessionRequest struct {
	*requests.RpcRequest
	IdpId       string `position:"Query" name:"IdpId"`
	ExternalIds string `position:"Query" name:"ExternalIds"`
}

// RevokeUserSessionResponse is the response struct for api RevokeUserSession
type RevokeUserSessionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeUserSessionRequest creates a request to invoke RevokeUserSession API
func CreateRevokeUserSessionRequest() (request *RevokeUserSessionRequest) {
	request = &RevokeUserSessionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "RevokeUserSession", "", "")
	request.Method = requests.POST
	return
}

// CreateRevokeUserSessionResponse creates a response to parse from RevokeUserSession response
func CreateRevokeUserSessionResponse() (response *RevokeUserSessionResponse) {
	response = &RevokeUserSessionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
