package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateResourcesByAdvancedSearch invokes the config.ListAggregateResourcesByAdvancedSearch API synchronously
func (client *Client) ListAggregateResourcesByAdvancedSearch(request *ListAggregateResourcesByAdvancedSearchRequest) (response *ListAggregateResourcesByAdvancedSearchResponse, err error) {
	response = CreateListAggregateResourcesByAdvancedSearchResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateResourcesByAdvancedSearchWithChan invokes the config.ListAggregateResourcesByAdvancedSearch API asynchronously
func (client *Client) ListAggregateResourcesByAdvancedSearchWithChan(request *ListAggregateResourcesByAdvancedSearchRequest) (<-chan *ListAggregateResourcesByAdvancedSearchResponse, <-chan error) {
	responseChan := make(chan *ListAggregateResourcesByAdvancedSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateResourcesByAdvancedSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateResourcesByAdvancedSearchWithCallback invokes the config.ListAggregateResourcesByAdvancedSearch API asynchronously
func (client *Client) ListAggregateResourcesByAdvancedSearchWithCallback(request *ListAggregateResourcesByAdvancedSearchRequest, callback func(response *ListAggregateResourcesByAdvancedSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateResourcesByAdvancedSearchResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateResourcesByAdvancedSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateResourcesByAdvancedSearchRequest is the request struct for api ListAggregateResourcesByAdvancedSearch
type ListAggregateResourcesByAdvancedSearchRequest struct {
	*requests.RpcRequest
	AggregatorId string `position:"Query" name:"AggregatorId"`
	Sql          string `position:"Query" name:"Sql"`
}

// ListAggregateResourcesByAdvancedSearchResponse is the response struct for api ListAggregateResourcesByAdvancedSearch
type ListAggregateResourcesByAdvancedSearchResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	QueryResults QueryResults `json:"QueryResults" xml:"QueryResults"`
}

// CreateListAggregateResourcesByAdvancedSearchRequest creates a request to invoke ListAggregateResourcesByAdvancedSearch API
func CreateListAggregateResourcesByAdvancedSearchRequest() (request *ListAggregateResourcesByAdvancedSearchRequest) {
	request = &ListAggregateResourcesByAdvancedSearchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateResourcesByAdvancedSearch", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateResourcesByAdvancedSearchResponse creates a response to parse from ListAggregateResourcesByAdvancedSearch response
func CreateListAggregateResourcesByAdvancedSearchResponse() (response *ListAggregateResourcesByAdvancedSearchResponse) {
	response = &ListAggregateResourcesByAdvancedSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
