package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomEventCount invokes the cms.DescribeCustomEventCount API synchronously
func (client *Client) DescribeCustomEventCount(request *DescribeCustomEventCountRequest) (response *DescribeCustomEventCountResponse, err error) {
	response = CreateDescribeCustomEventCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomEventCountWithChan invokes the cms.DescribeCustomEventCount API asynchronously
func (client *Client) DescribeCustomEventCountWithChan(request *DescribeCustomEventCountRequest) (<-chan *DescribeCustomEventCountResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomEventCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomEventCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomEventCountWithCallback invokes the cms.DescribeCustomEventCount API asynchronously
func (client *Client) DescribeCustomEventCountWithCallback(request *DescribeCustomEventCountRequest, callback func(response *DescribeCustomEventCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomEventCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomEventCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomEventCountRequest is the request struct for api DescribeCustomEventCount
type DescribeCustomEventCountRequest struct {
	*requests.RpcRequest
	EventId        string `position:"Query" name:"EventId"`
	GroupId        string `position:"Query" name:"GroupId"`
	EndTime        string `position:"Query" name:"EndTime"`
	StartTime      string `position:"Query" name:"StartTime"`
	SearchKeywords string `position:"Query" name:"SearchKeywords"`
	Name           string `position:"Query" name:"Name"`
}

// DescribeCustomEventCountResponse is the response struct for api DescribeCustomEventCount
type DescribeCustomEventCountResponse struct {
	*responses.BaseResponse
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           bool              `json:"Success" xml:"Success"`
	CustomEventCounts CustomEventCounts `json:"CustomEventCounts" xml:"CustomEventCounts"`
}

// CreateDescribeCustomEventCountRequest creates a request to invoke DescribeCustomEventCount API
func CreateDescribeCustomEventCountRequest() (request *DescribeCustomEventCountRequest) {
	request = &DescribeCustomEventCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeCustomEventCount", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomEventCountResponse creates a response to parse from DescribeCustomEventCount response
func CreateDescribeCustomEventCountResponse() (response *DescribeCustomEventCountResponse) {
	response = &DescribeCustomEventCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
