package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBizLines invokes the biz_ipdb.DescribeBizLines API synchronously
func (client *Client) DescribeBizLines(request *DescribeBizLinesRequest) (response *DescribeBizLinesResponse, err error) {
	response = CreateDescribeBizLinesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBizLinesWithChan invokes the biz_ipdb.DescribeBizLines API asynchronously
func (client *Client) DescribeBizLinesWithChan(request *DescribeBizLinesRequest) (<-chan *DescribeBizLinesResponse, <-chan error) {
	responseChan := make(chan *DescribeBizLinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBizLines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBizLinesWithCallback invokes the biz_ipdb.DescribeBizLines API asynchronously
func (client *Client) DescribeBizLinesWithCallback(request *DescribeBizLinesRequest, callback func(response *DescribeBizLinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBizLinesResponse
		var err error
		defer close(result)
		response, err = client.DescribeBizLines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBizLinesRequest is the request struct for api DescribeBizLines
type DescribeBizLinesRequest struct {
	*requests.RpcRequest
	BizLine string `position:"Query" name:"BizLine"`
}

// DescribeBizLinesResponse is the response struct for api DescribeBizLines
type DescribeBizLinesResponse struct {
	*responses.BaseResponse
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	BizLineSet BizLineSet `json:"BizLineSet" xml:"BizLineSet"`
}

// CreateDescribeBizLinesRequest creates a request to invoke DescribeBizLines API
func CreateDescribeBizLinesRequest() (request *DescribeBizLinesRequest) {
	request = &DescribeBizLinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "DescribeBizLines", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBizLinesResponse creates a response to parse from DescribeBizLines response
func CreateDescribeBizLinesResponse() (response *DescribeBizLinesResponse) {
	response = &DescribeBizLinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
