package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchEvents invokes the arms.SearchEvents API synchronously
func (client *Client) SearchEvents(request *SearchEventsRequest) (response *SearchEventsResponse, err error) {
	response = CreateSearchEventsResponse()
	err = client.DoAction(request, response)
	return
}

// SearchEventsWithChan invokes the arms.SearchEvents API asynchronously
func (client *Client) SearchEventsWithChan(request *SearchEventsRequest) (<-chan *SearchEventsResponse, <-chan error) {
	responseChan := make(chan *SearchEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchEventsWithCallback invokes the arms.SearchEvents API asynchronously
func (client *Client) SearchEventsWithCallback(request *SearchEventsRequest, callback func(response *SearchEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchEventsResponse
		var err error
		defer close(result)
		response, err = client.SearchEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchEventsRequest is the request struct for api SearchEvents
type SearchEventsRequest struct {
	*requests.RpcRequest
	IsTrigger   requests.Integer `position:"Query" name:"IsTrigger"`
	AppType     string           `position:"Query" name:"AppType"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	Pid         string           `position:"Query" name:"Pid"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	ProxyUserId string           `position:"Query" name:"ProxyUserId"`
	AlertType   requests.Integer `position:"Query" name:"AlertType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	AlertId     requests.Integer `position:"Query" name:"AlertId"`
}

// SearchEventsResponse is the response struct for api SearchEvents
type SearchEventsResponse struct {
	*responses.BaseResponse
	IsTrigger int      `json:"IsTrigger" xml:"IsTrigger"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateSearchEventsRequest creates a request to invoke SearchEvents API
func CreateSearchEventsRequest() (request *SearchEventsRequest) {
	request = &SearchEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchEvents", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchEventsResponse creates a response to parse from SearchEvents response
func CreateSearchEventsResponse() (response *SearchEventsResponse) {
	response = &SearchEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
