package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSurveyResourceTag invokes the apds.DescribeSurveyResourceTag API synchronously
func (client *Client) DescribeSurveyResourceTag(request *DescribeSurveyResourceTagRequest) (response *DescribeSurveyResourceTagResponse, err error) {
	response = CreateDescribeSurveyResourceTagResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSurveyResourceTagWithChan invokes the apds.DescribeSurveyResourceTag API asynchronously
func (client *Client) DescribeSurveyResourceTagWithChan(request *DescribeSurveyResourceTagRequest) (<-chan *DescribeSurveyResourceTagResponse, <-chan error) {
	responseChan := make(chan *DescribeSurveyResourceTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSurveyResourceTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSurveyResourceTagWithCallback invokes the apds.DescribeSurveyResourceTag API asynchronously
func (client *Client) DescribeSurveyResourceTagWithCallback(request *DescribeSurveyResourceTagRequest, callback func(response *DescribeSurveyResourceTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSurveyResourceTagResponse
		var err error
		defer close(result)
		response, err = client.DescribeSurveyResourceTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSurveyResourceTagRequest is the request struct for api DescribeSurveyResourceTag
type DescribeSurveyResourceTagRequest struct {
	*requests.RoaRequest
}

// DescribeSurveyResourceTagResponse is the response struct for api DescribeSurveyResourceTag
type DescribeSurveyResourceTagResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"Error" xml:"Error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDescribeSurveyResourceTagRequest creates a request to invoke DescribeSurveyResourceTag API
func CreateDescribeSurveyResourceTagRequest() (request *DescribeSurveyResourceTagRequest) {
	request = &DescribeSurveyResourceTagRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DescribeSurveyResourceTag", "/okss-services/confirm-resource/get-resource-tag", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSurveyResourceTagResponse creates a response to parse from DescribeSurveyResourceTag response
func CreateDescribeSurveyResourceTagResponse() (response *DescribeSurveyResourceTagResponse) {
	response = &DescribeSurveyResourceTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
