package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExchanges invokes the amqp_open.ListExchanges API synchronously
func (client *Client) ListExchanges(request *ListExchangesRequest) (response *ListExchangesResponse, err error) {
	response = CreateListExchangesResponse()
	err = client.DoAction(request, response)
	return
}

// ListExchangesWithChan invokes the amqp_open.ListExchanges API asynchronously
func (client *Client) ListExchangesWithChan(request *ListExchangesRequest) (<-chan *ListExchangesResponse, <-chan error) {
	responseChan := make(chan *ListExchangesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExchanges(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExchangesWithCallback invokes the amqp_open.ListExchanges API asynchronously
func (client *Client) ListExchangesWithCallback(request *ListExchangesRequest, callback func(response *ListExchangesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExchangesResponse
		var err error
		defer close(result)
		response, err = client.ListExchanges(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExchangesRequest is the request struct for api ListExchanges
type ListExchangesRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query" name:"InstanceId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
	VirtualHost string           `position:"Query" name:"VirtualHost"`
}

// ListExchangesResponse is the response struct for api ListExchanges
type ListExchangesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListExchangesRequest creates a request to invoke ListExchanges API
func CreateListExchangesRequest() (request *ListExchangesRequest) {
	request = &ListExchangesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListExchanges", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListExchangesResponse creates a response to parse from ListExchanges response
func CreateListExchangesResponse() (response *ListExchangesResponse) {
	response = &ListExchangesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
