package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDpChGeneralCTB invokes the alinlp.GetDpChGeneralCTB API synchronously
func (client *Client) GetDpChGeneralCTB(request *GetDpChGeneralCTBRequest) (response *GetDpChGeneralCTBResponse, err error) {
	response = CreateGetDpChGeneralCTBResponse()
	err = client.DoAction(request, response)
	return
}

// GetDpChGeneralCTBWithChan invokes the alinlp.GetDpChGeneralCTB API asynchronously
func (client *Client) GetDpChGeneralCTBWithChan(request *GetDpChGeneralCTBRequest) (<-chan *GetDpChGeneralCTBResponse, <-chan error) {
	responseChan := make(chan *GetDpChGeneralCTBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDpChGeneralCTB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDpChGeneralCTBWithCallback invokes the alinlp.GetDpChGeneralCTB API asynchronously
func (client *Client) GetDpChGeneralCTBWithCallback(request *GetDpChGeneralCTBRequest, callback func(response *GetDpChGeneralCTBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDpChGeneralCTBResponse
		var err error
		defer close(result)
		response, err = client.GetDpChGeneralCTB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDpChGeneralCTBRequest is the request struct for api GetDpChGeneralCTB
type GetDpChGeneralCTBRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetDpChGeneralCTBResponse is the response struct for api GetDpChGeneralCTB
type GetDpChGeneralCTBResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetDpChGeneralCTBRequest creates a request to invoke GetDpChGeneralCTB API
func CreateGetDpChGeneralCTBRequest() (request *GetDpChGeneralCTBRequest) {
	request = &GetDpChGeneralCTBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetDpChGeneralCTB", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDpChGeneralCTBResponse creates a response to parse from GetDpChGeneralCTB response
func CreateGetDpChGeneralCTBResponse() (response *GetDpChGeneralCTBResponse) {
	response = &GetDpChGeneralCTBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
