package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiagnosisChMedical invokes the alinlp.GetDiagnosisChMedical API synchronously
func (client *Client) GetDiagnosisChMedical(request *GetDiagnosisChMedicalRequest) (response *GetDiagnosisChMedicalResponse, err error) {
	response = CreateGetDiagnosisChMedicalResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiagnosisChMedicalWithChan invokes the alinlp.GetDiagnosisChMedical API asynchronously
func (client *Client) GetDiagnosisChMedicalWithChan(request *GetDiagnosisChMedicalRequest) (<-chan *GetDiagnosisChMedicalResponse, <-chan error) {
	responseChan := make(chan *GetDiagnosisChMedicalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiagnosisChMedical(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiagnosisChMedicalWithCallback invokes the alinlp.GetDiagnosisChMedical API asynchronously
func (client *Client) GetDiagnosisChMedicalWithCallback(request *GetDiagnosisChMedicalRequest, callback func(response *GetDiagnosisChMedicalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiagnosisChMedicalResponse
		var err error
		defer close(result)
		response, err = client.GetDiagnosisChMedical(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiagnosisChMedicalRequest is the request struct for api GetDiagnosisChMedical
type GetDiagnosisChMedicalRequest struct {
	*requests.RpcRequest
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Name        string `position:"Body" name:"Name"`
}

// GetDiagnosisChMedicalResponse is the response struct for api GetDiagnosisChMedical
type GetDiagnosisChMedicalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetDiagnosisChMedicalRequest creates a request to invoke GetDiagnosisChMedical API
func CreateGetDiagnosisChMedicalRequest() (request *GetDiagnosisChMedicalRequest) {
	request = &GetDiagnosisChMedicalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetDiagnosisChMedical", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDiagnosisChMedicalResponse creates a response to parse from GetDiagnosisChMedical response
func CreateGetDiagnosisChMedicalResponse() (response *GetDiagnosisChMedicalResponse) {
	response = &GetDiagnosisChMedicalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
