package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIsolationRulesOfApp invokes the ahas_openapi.ListIsolationRulesOfApp API synchronously
func (client *Client) ListIsolationRulesOfApp(request *ListIsolationRulesOfAppRequest) (response *ListIsolationRulesOfAppResponse, err error) {
	response = CreateListIsolationRulesOfAppResponse()
	err = client.DoAction(request, response)
	return
}

// ListIsolationRulesOfAppWithChan invokes the ahas_openapi.ListIsolationRulesOfApp API asynchronously
func (client *Client) ListIsolationRulesOfAppWithChan(request *ListIsolationRulesOfAppRequest) (<-chan *ListIsolationRulesOfAppResponse, <-chan error) {
	responseChan := make(chan *ListIsolationRulesOfAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIsolationRulesOfApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIsolationRulesOfAppWithCallback invokes the ahas_openapi.ListIsolationRulesOfApp API asynchronously
func (client *Client) ListIsolationRulesOfAppWithCallback(request *ListIsolationRulesOfAppRequest, callback func(response *ListIsolationRulesOfAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIsolationRulesOfAppResponse
		var err error
		defer close(result)
		response, err = client.ListIsolationRulesOfApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIsolationRulesOfAppRequest is the request struct for api ListIsolationRulesOfApp
type ListIsolationRulesOfAppRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListIsolationRulesOfAppResponse is the response struct for api ListIsolationRulesOfApp
type ListIsolationRulesOfAppResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListIsolationRulesOfAppRequest creates a request to invoke ListIsolationRulesOfApp API
func CreateListIsolationRulesOfAppRequest() (request *ListIsolationRulesOfAppRequest) {
	request = &ListIsolationRulesOfAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListIsolationRulesOfApp", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIsolationRulesOfAppResponse creates a response to parse from ListIsolationRulesOfApp response
func CreateListIsolationRulesOfAppResponse() (response *ListIsolationRulesOfAppResponse) {
	response = &ListIsolationRulesOfAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
