// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/supervisor/idp/v1alpha1"
	scheme "go.pinniped.dev/generated/latest/client/supervisor/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// LDAPIdentityProvidersGetter has a method to return a LDAPIdentityProviderInterface.
// A group's client should implement this interface.
type LDAPIdentityProvidersGetter interface {
	LDAPIdentityProviders(namespace string) LDAPIdentityProviderInterface
}

// LDAPIdentityProviderInterface has methods to work with LDAPIdentityProvider resources.
type LDAPIdentityProviderInterface interface {
	Create(ctx context.Context, lDAPIdentityProvider *v1alpha1.LDAPIdentityProvider, opts v1.CreateOptions) (*v1alpha1.LDAPIdentityProvider, error)
	Update(ctx context.Context, lDAPIdentityProvider *v1alpha1.LDAPIdentityProvider, opts v1.UpdateOptions) (*v1alpha1.LDAPIdentityProvider, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, lDAPIdentityProvider *v1alpha1.LDAPIdentityProvider, opts v1.UpdateOptions) (*v1alpha1.LDAPIdentityProvider, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.LDAPIdentityProvider, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.LDAPIdentityProviderList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.LDAPIdentityProvider, err error)
	LDAPIdentityProviderExpansion
}

// lDAPIdentityProviders implements LDAPIdentityProviderInterface
type lDAPIdentityProviders struct {
	*gentype.ClientWithList[*v1alpha1.LDAPIdentityProvider, *v1alpha1.LDAPIdentityProviderList]
}

// newLDAPIdentityProviders returns a LDAPIdentityProviders
func newLDAPIdentityProviders(c *IDPV1alpha1Client, namespace string) *lDAPIdentityProviders {
	return &lDAPIdentityProviders{
		gentype.NewClientWithList[*v1alpha1.LDAPIdentityProvider, *v1alpha1.LDAPIdentityProviderList](
			"ldapidentityproviders",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.LDAPIdentityProvider { return &v1alpha1.LDAPIdentityProvider{} },
			func() *v1alpha1.LDAPIdentityProviderList { return &v1alpha1.LDAPIdentityProviderList{} }),
	}
}
