// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1alpha1 "go.pinniped.dev/generated/latest/apis/concierge/config/v1alpha1"
	scheme "go.pinniped.dev/generated/latest/client/concierge/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CredentialIssuersGetter has a method to return a CredentialIssuerInterface.
// A group's client should implement this interface.
type CredentialIssuersGetter interface {
	CredentialIssuers() CredentialIssuerInterface
}

// CredentialIssuerInterface has methods to work with CredentialIssuer resources.
type CredentialIssuerInterface interface {
	Create(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.CreateOptions) (*v1alpha1.CredentialIssuer, error)
	Update(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.UpdateOptions) (*v1alpha1.CredentialIssuer, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, credentialIssuer *v1alpha1.CredentialIssuer, opts v1.UpdateOptions) (*v1alpha1.CredentialIssuer, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.CredentialIssuer, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.CredentialIssuerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.CredentialIssuer, err error)
	CredentialIssuerExpansion
}

// credentialIssuers implements CredentialIssuerInterface
type credentialIssuers struct {
	*gentype.ClientWithList[*v1alpha1.CredentialIssuer, *v1alpha1.CredentialIssuerList]
}

// newCredentialIssuers returns a CredentialIssuers
func newCredentialIssuers(c *ConfigV1alpha1Client) *credentialIssuers {
	return &credentialIssuers{
		gentype.NewClientWithList[*v1alpha1.CredentialIssuer, *v1alpha1.CredentialIssuerList](
			"credentialissuers",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1alpha1.CredentialIssuer { return &v1alpha1.CredentialIssuer{} },
			func() *v1alpha1.CredentialIssuerList { return &v1alpha1.CredentialIssuerList{} }),
	}
}
