// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateSslVpnServerCommon = "CreateSslVpnServer"

// CreateSslVpnServerCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSslVpnServerCommon operation. The "output" return
// value will be populated with the CreateSslVpnServerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSslVpnServerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSslVpnServerCommon Send returns without error.
//
// See CreateSslVpnServerCommon for more information on using the CreateSslVpnServerCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateSslVpnServerCommonRequest method.
//    req, resp := client.CreateSslVpnServerCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPN) CreateSslVpnServerCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateSslVpnServerCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateSslVpnServerCommon API operation for VPN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPN's
// API operation CreateSslVpnServerCommon for usage and error information.
func (c *VPN) CreateSslVpnServerCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateSslVpnServerCommonRequest(input)
	return out, req.Send()
}

// CreateSslVpnServerCommonWithContext is the same as CreateSslVpnServerCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSslVpnServerCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPN) CreateSslVpnServerCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateSslVpnServerCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSslVpnServer = "CreateSslVpnServer"

// CreateSslVpnServerRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSslVpnServer operation. The "output" return
// value will be populated with the CreateSslVpnServerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSslVpnServerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSslVpnServerCommon Send returns without error.
//
// See CreateSslVpnServer for more information on using the CreateSslVpnServer
// API call, and error handling.
//
//    // Example sending a request using the CreateSslVpnServerRequest method.
//    req, resp := client.CreateSslVpnServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPN) CreateSslVpnServerRequest(input *CreateSslVpnServerInput) (req *request.Request, output *CreateSslVpnServerOutput) {
	op := &request.Operation{
		Name:       opCreateSslVpnServer,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSslVpnServerInput{}
	}

	output = &CreateSslVpnServerOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateSslVpnServer API operation for VPN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPN's
// API operation CreateSslVpnServer for usage and error information.
func (c *VPN) CreateSslVpnServer(input *CreateSslVpnServerInput) (*CreateSslVpnServerOutput, error) {
	req, out := c.CreateSslVpnServerRequest(input)
	return out, req.Send()
}

// CreateSslVpnServerWithContext is the same as CreateSslVpnServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSslVpnServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPN) CreateSslVpnServerWithContext(ctx volcengine.Context, input *CreateSslVpnServerInput, opts ...request.Option) (*CreateSslVpnServerOutput, error) {
	req, out := c.CreateSslVpnServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateSslVpnServerInput struct {
	_ struct{} `type:"structure"`

	Auth *string `type:"string"`

	Cipher *string `type:"string"`

	// ClientIpPool is a required field
	ClientIpPool *string `type:"string" required:"true"`

	ClientToken *string `type:"string"`

	Compress *bool `type:"boolean"`

	Description *string `type:"string"`

	// LocalSubnets is a required field
	LocalSubnets []*string `type:"list" required:"true"`

	Port *int64 `type:"integer"`

	ProjectName *string `type:"string"`

	Protocol *string `type:"string"`

	SslVpnServerName *string `type:"string"`

	// VpnGatewayId is a required field
	VpnGatewayId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSslVpnServerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSslVpnServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSslVpnServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSslVpnServerInput"}
	if s.ClientIpPool == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientIpPool"))
	}
	if s.LocalSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalSubnets"))
	}
	if s.VpnGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnGatewayId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuth sets the Auth field's value.
func (s *CreateSslVpnServerInput) SetAuth(v string) *CreateSslVpnServerInput {
	s.Auth = &v
	return s
}

// SetCipher sets the Cipher field's value.
func (s *CreateSslVpnServerInput) SetCipher(v string) *CreateSslVpnServerInput {
	s.Cipher = &v
	return s
}

// SetClientIpPool sets the ClientIpPool field's value.
func (s *CreateSslVpnServerInput) SetClientIpPool(v string) *CreateSslVpnServerInput {
	s.ClientIpPool = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSslVpnServerInput) SetClientToken(v string) *CreateSslVpnServerInput {
	s.ClientToken = &v
	return s
}

// SetCompress sets the Compress field's value.
func (s *CreateSslVpnServerInput) SetCompress(v bool) *CreateSslVpnServerInput {
	s.Compress = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSslVpnServerInput) SetDescription(v string) *CreateSslVpnServerInput {
	s.Description = &v
	return s
}

// SetLocalSubnets sets the LocalSubnets field's value.
func (s *CreateSslVpnServerInput) SetLocalSubnets(v []*string) *CreateSslVpnServerInput {
	s.LocalSubnets = v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateSslVpnServerInput) SetPort(v int64) *CreateSslVpnServerInput {
	s.Port = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateSslVpnServerInput) SetProjectName(v string) *CreateSslVpnServerInput {
	s.ProjectName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateSslVpnServerInput) SetProtocol(v string) *CreateSslVpnServerInput {
	s.Protocol = &v
	return s
}

// SetSslVpnServerName sets the SslVpnServerName field's value.
func (s *CreateSslVpnServerInput) SetSslVpnServerName(v string) *CreateSslVpnServerInput {
	s.SslVpnServerName = &v
	return s
}

// SetVpnGatewayId sets the VpnGatewayId field's value.
func (s *CreateSslVpnServerInput) SetVpnGatewayId(v string) *CreateSslVpnServerInput {
	s.VpnGatewayId = &v
	return s
}

type CreateSslVpnServerOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`

	SslVpnServerId *string `type:"string"`
}

// String returns the string representation
func (s CreateSslVpnServerOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSslVpnServerOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateSslVpnServerOutput) SetRequestId(v string) *CreateSslVpnServerOutput {
	s.RequestId = &v
	return s
}

// SetSslVpnServerId sets the SslVpnServerId field's value.
func (s *CreateSslVpnServerOutput) SetSslVpnServerId(v string) *CreateSslVpnServerOutput {
	s.SslVpnServerId = &v
	return s
}
