// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeFlowLogsCommon = "DescribeFlowLogs"

// DescribeFlowLogsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFlowLogsCommon operation. The "output" return
// value will be populated with the DescribeFlowLogsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFlowLogsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFlowLogsCommon Send returns without error.
//
// See DescribeFlowLogsCommon for more information on using the DescribeFlowLogsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeFlowLogsCommonRequest method.
//    req, resp := client.DescribeFlowLogsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeFlowLogsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeFlowLogsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeFlowLogsCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeFlowLogsCommon for usage and error information.
func (c *VPC) DescribeFlowLogsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeFlowLogsCommonRequest(input)
	return out, req.Send()
}

// DescribeFlowLogsCommonWithContext is the same as DescribeFlowLogsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowLogsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeFlowLogsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeFlowLogsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlowLogs = "DescribeFlowLogs"

// DescribeFlowLogsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFlowLogs operation. The "output" return
// value will be populated with the DescribeFlowLogsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFlowLogsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFlowLogsCommon Send returns without error.
//
// See DescribeFlowLogs for more information on using the DescribeFlowLogs
// API call, and error handling.
//
//    // Example sending a request using the DescribeFlowLogsRequest method.
//    req, resp := client.DescribeFlowLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeFlowLogsRequest(input *DescribeFlowLogsInput) (req *request.Request, output *DescribeFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowLogs,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlowLogsInput{}
	}

	output = &DescribeFlowLogsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeFlowLogs API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeFlowLogs for usage and error information.
func (c *VPC) DescribeFlowLogs(input *DescribeFlowLogsInput) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	return out, req.Send()
}

// DescribeFlowLogsWithContext is the same as DescribeFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeFlowLogsWithContext(ctx volcengine.Context, input *DescribeFlowLogsInput, opts ...request.Option) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeFlowLogsInput struct {
	_ struct{} `type:"structure"`

	AggregationInterval *int64 `type:"integer"`

	Description *string `type:"string"`

	FlowLogIds []*string `type:"list"`

	FlowLogName *string `type:"string"`

	LogProjectId *string `type:"string"`

	LogTopicId *string `type:"string"`

	MaxResults *int64 `type:"integer"`

	NextToken *string `type:"string"`

	ProjectName *string `type:"string"`

	ResourceId *string `type:"string"`

	ResourceType *string `type:"string"`

	Status *string `type:"string"`

	TagFilters []*TagFilterForDescribeFlowLogsInput `type:"list"`

	TrafficType *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsInput) GoString() string {
	return s.String()
}

// SetAggregationInterval sets the AggregationInterval field's value.
func (s *DescribeFlowLogsInput) SetAggregationInterval(v int64) *DescribeFlowLogsInput {
	s.AggregationInterval = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeFlowLogsInput) SetDescription(v string) *DescribeFlowLogsInput {
	s.Description = &v
	return s
}

// SetFlowLogIds sets the FlowLogIds field's value.
func (s *DescribeFlowLogsInput) SetFlowLogIds(v []*string) *DescribeFlowLogsInput {
	s.FlowLogIds = v
	return s
}

// SetFlowLogName sets the FlowLogName field's value.
func (s *DescribeFlowLogsInput) SetFlowLogName(v string) *DescribeFlowLogsInput {
	s.FlowLogName = &v
	return s
}

// SetLogProjectId sets the LogProjectId field's value.
func (s *DescribeFlowLogsInput) SetLogProjectId(v string) *DescribeFlowLogsInput {
	s.LogProjectId = &v
	return s
}

// SetLogTopicId sets the LogTopicId field's value.
func (s *DescribeFlowLogsInput) SetLogTopicId(v string) *DescribeFlowLogsInput {
	s.LogTopicId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeFlowLogsInput) SetMaxResults(v int64) *DescribeFlowLogsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowLogsInput) SetNextToken(v string) *DescribeFlowLogsInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeFlowLogsInput) SetProjectName(v string) *DescribeFlowLogsInput {
	s.ProjectName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeFlowLogsInput) SetResourceId(v string) *DescribeFlowLogsInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeFlowLogsInput) SetResourceType(v string) *DescribeFlowLogsInput {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFlowLogsInput) SetStatus(v string) *DescribeFlowLogsInput {
	s.Status = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeFlowLogsInput) SetTagFilters(v []*TagFilterForDescribeFlowLogsInput) *DescribeFlowLogsInput {
	s.TagFilters = v
	return s
}

// SetTrafficType sets the TrafficType field's value.
func (s *DescribeFlowLogsInput) SetTrafficType(v string) *DescribeFlowLogsInput {
	s.TrafficType = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeFlowLogsInput) SetVpcId(v string) *DescribeFlowLogsInput {
	s.VpcId = &v
	return s
}

type DescribeFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	FlowLogs []*FlowLogForDescribeFlowLogsOutput `type:"list"`

	NextToken *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DescribeFlowLogsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowLogsOutput) GoString() string {
	return s.String()
}

// SetFlowLogs sets the FlowLogs field's value.
func (s *DescribeFlowLogsOutput) SetFlowLogs(v []*FlowLogForDescribeFlowLogsOutput) *DescribeFlowLogsOutput {
	s.FlowLogs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFlowLogsOutput) SetNextToken(v string) *DescribeFlowLogsOutput {
	s.NextToken = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeFlowLogsOutput) SetRequestId(v string) *DescribeFlowLogsOutput {
	s.RequestId = &v
	return s
}

type FlowLogForDescribeFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	AccountId *string `type:"string"`

	AggregationInterval *int64 `type:"integer"`

	BusinessStatus *string `type:"string"`

	CreatedAt *string `type:"string"`

	Description *string `type:"string"`

	FlowLogId *string `type:"string"`

	FlowLogName *string `type:"string"`

	LockReason *string `type:"string"`

	LogProjectId *string `type:"string"`

	LogTopicId *string `type:"string"`

	OpenAnalyzeProductLog *bool `type:"boolean"`

	ProjectName *string `type:"string"`

	ResourceId *string `type:"string"`

	ResourceType *string `type:"string"`

	Status *string `type:"string"`

	Tags []*TagForDescribeFlowLogsOutput `type:"list"`

	TrafficType *string `type:"string" enum:"TrafficTypeForDescribeFlowLogsOutput"`

	UpdatedAt *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s FlowLogForDescribeFlowLogsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowLogForDescribeFlowLogsOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetAccountId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.AccountId = &v
	return s
}

// SetAggregationInterval sets the AggregationInterval field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetAggregationInterval(v int64) *FlowLogForDescribeFlowLogsOutput {
	s.AggregationInterval = &v
	return s
}

// SetBusinessStatus sets the BusinessStatus field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetBusinessStatus(v string) *FlowLogForDescribeFlowLogsOutput {
	s.BusinessStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetCreatedAt(v string) *FlowLogForDescribeFlowLogsOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetDescription(v string) *FlowLogForDescribeFlowLogsOutput {
	s.Description = &v
	return s
}

// SetFlowLogId sets the FlowLogId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetFlowLogId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.FlowLogId = &v
	return s
}

// SetFlowLogName sets the FlowLogName field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetFlowLogName(v string) *FlowLogForDescribeFlowLogsOutput {
	s.FlowLogName = &v
	return s
}

// SetLockReason sets the LockReason field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetLockReason(v string) *FlowLogForDescribeFlowLogsOutput {
	s.LockReason = &v
	return s
}

// SetLogProjectId sets the LogProjectId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetLogProjectId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.LogProjectId = &v
	return s
}

// SetLogTopicId sets the LogTopicId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetLogTopicId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.LogTopicId = &v
	return s
}

// SetOpenAnalyzeProductLog sets the OpenAnalyzeProductLog field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetOpenAnalyzeProductLog(v bool) *FlowLogForDescribeFlowLogsOutput {
	s.OpenAnalyzeProductLog = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetProjectName(v string) *FlowLogForDescribeFlowLogsOutput {
	s.ProjectName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetResourceId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetResourceType(v string) *FlowLogForDescribeFlowLogsOutput {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetStatus(v string) *FlowLogForDescribeFlowLogsOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetTags(v []*TagForDescribeFlowLogsOutput) *FlowLogForDescribeFlowLogsOutput {
	s.Tags = v
	return s
}

// SetTrafficType sets the TrafficType field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetTrafficType(v string) *FlowLogForDescribeFlowLogsOutput {
	s.TrafficType = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetUpdatedAt(v string) *FlowLogForDescribeFlowLogsOutput {
	s.UpdatedAt = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FlowLogForDescribeFlowLogsOutput) SetVpcId(v string) *FlowLogForDescribeFlowLogsOutput {
	s.VpcId = &v
	return s
}

type TagFilterForDescribeFlowLogsInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilterForDescribeFlowLogsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeFlowLogsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeFlowLogsInput) SetKey(v string) *TagFilterForDescribeFlowLogsInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForDescribeFlowLogsInput) SetValues(v []*string) *TagFilterForDescribeFlowLogsInput {
	s.Values = v
	return s
}

type TagForDescribeFlowLogsOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDescribeFlowLogsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeFlowLogsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeFlowLogsOutput) SetKey(v string) *TagForDescribeFlowLogsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeFlowLogsOutput) SetValue(v string) *TagForDescribeFlowLogsOutput {
	s.Value = &v
	return s
}

const (
	// TrafficTypeForDescribeFlowLogsOutputAll is a TrafficTypeForDescribeFlowLogsOutput enum value
	TrafficTypeForDescribeFlowLogsOutputAll = "All"

	// TrafficTypeForDescribeFlowLogsOutputAllow is a TrafficTypeForDescribeFlowLogsOutput enum value
	TrafficTypeForDescribeFlowLogsOutputAllow = "Allow"

	// TrafficTypeForDescribeFlowLogsOutputDrop is a TrafficTypeForDescribeFlowLogsOutput enum value
	TrafficTypeForDescribeFlowLogsOutputDrop = "Drop"
)
