// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vke

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDefaultNodePoolCommon = "CreateDefaultNodePool"

// CreateDefaultNodePoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDefaultNodePoolCommon operation. The "output" return
// value will be populated with the CreateDefaultNodePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDefaultNodePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDefaultNodePoolCommon Send returns without error.
//
// See CreateDefaultNodePoolCommon for more information on using the CreateDefaultNodePoolCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDefaultNodePoolCommonRequest method.
//    req, resp := client.CreateDefaultNodePoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateDefaultNodePoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDefaultNodePoolCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDefaultNodePoolCommon API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateDefaultNodePoolCommon for usage and error information.
func (c *VKE) CreateDefaultNodePoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDefaultNodePoolCommonRequest(input)
	return out, req.Send()
}

// CreateDefaultNodePoolCommonWithContext is the same as CreateDefaultNodePoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultNodePoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateDefaultNodePoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDefaultNodePoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultNodePool = "CreateDefaultNodePool"

// CreateDefaultNodePoolRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDefaultNodePool operation. The "output" return
// value will be populated with the CreateDefaultNodePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDefaultNodePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDefaultNodePoolCommon Send returns without error.
//
// See CreateDefaultNodePool for more information on using the CreateDefaultNodePool
// API call, and error handling.
//
//    // Example sending a request using the CreateDefaultNodePoolRequest method.
//    req, resp := client.CreateDefaultNodePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VKE) CreateDefaultNodePoolRequest(input *CreateDefaultNodePoolInput) (req *request.Request, output *CreateDefaultNodePoolOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultNodePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultNodePoolInput{}
	}

	output = &CreateDefaultNodePoolOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDefaultNodePool API operation for VKE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VKE's
// API operation CreateDefaultNodePool for usage and error information.
func (c *VKE) CreateDefaultNodePool(input *CreateDefaultNodePoolInput) (*CreateDefaultNodePoolOutput, error) {
	req, out := c.CreateDefaultNodePoolRequest(input)
	return out, req.Send()
}

// CreateDefaultNodePoolWithContext is the same as CreateDefaultNodePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultNodePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VKE) CreateDefaultNodePoolWithContext(ctx volcengine.Context, input *CreateDefaultNodePoolInput, opts ...request.Option) (*CreateDefaultNodePoolOutput, error) {
	req, out := c.CreateDefaultNodePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	KubernetesConfig *KubernetesConfigForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	NodeConfig *NodeConfigForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDefaultNodePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDefaultNodePoolInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDefaultNodePoolInput) SetClientToken(v string) *CreateDefaultNodePoolInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateDefaultNodePoolInput) SetClusterId(v string) *CreateDefaultNodePoolInput {
	s.ClusterId = &v
	return s
}

// SetKubernetesConfig sets the KubernetesConfig field's value.
func (s *CreateDefaultNodePoolInput) SetKubernetesConfig(v *KubernetesConfigForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.KubernetesConfig = v
	return s
}

// SetNodeConfig sets the NodeConfig field's value.
func (s *CreateDefaultNodePoolInput) SetNodeConfig(v *NodeConfigForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.NodeConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDefaultNodePoolInput) SetTags(v []*TagForCreateDefaultNodePoolInput) *CreateDefaultNodePoolInput {
	s.Tags = v
	return s
}

type CreateDefaultNodePoolOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDefaultNodePoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDefaultNodePoolOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateDefaultNodePoolOutput) SetId(v string) *CreateDefaultNodePoolOutput {
	s.Id = &v
	return s
}

type KubernetesConfigForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoSyncDisabled *bool `type:"boolean" json:",omitempty"`

	Cordon *bool `type:"boolean" json:",omitempty"`

	Labels []*LabelForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Taints []*TaintForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s KubernetesConfigForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesConfigForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetAutoSyncDisabled sets the AutoSyncDisabled field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetAutoSyncDisabled(v bool) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.AutoSyncDisabled = &v
	return s
}

// SetCordon sets the Cordon field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetCordon(v bool) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Cordon = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetLabels(v []*LabelForCreateDefaultNodePoolInput) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Labels = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetNamePrefix(v string) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.NamePrefix = &v
	return s
}

// SetTaints sets the Taints field's value.
func (s *KubernetesConfigForCreateDefaultNodePoolInput) SetTaints(v []*TaintForCreateDefaultNodePoolInput) *KubernetesConfigForCreateDefaultNodePoolInput {
	s.Taints = v
	return s
}

type LabelForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LabelForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForCreateDefaultNodePoolInput) SetKey(v string) *LabelForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LabelForCreateDefaultNodePoolInput) SetValue(v string) *LabelForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

type LoginForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Password *string `type:"string" json:",omitempty"`

	SshKeyPairName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LoginForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *LoginForCreateDefaultNodePoolInput) SetPassword(v string) *LoginForCreateDefaultNodePoolInput {
	s.Password = &v
	return s
}

// SetSshKeyPairName sets the SshKeyPairName field's value.
func (s *LoginForCreateDefaultNodePoolInput) SetSshKeyPairName(v string) *LoginForCreateDefaultNodePoolInput {
	s.SshKeyPairName = &v
	return s
}

type NodeConfigForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InitializeScript *string `type:"string" json:",omitempty"`

	NamePrefix *string `type:"string" json:",omitempty"`

	Security *SecurityForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateDefaultNodePoolInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s NodeConfigForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetInitializeScript sets the InitializeScript field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetInitializeScript(v string) *NodeConfigForCreateDefaultNodePoolInput {
	s.InitializeScript = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetNamePrefix(v string) *NodeConfigForCreateDefaultNodePoolInput {
	s.NamePrefix = &v
	return s
}

// SetSecurity sets the Security field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetSecurity(v *SecurityForCreateDefaultNodePoolInput) *NodeConfigForCreateDefaultNodePoolInput {
	s.Security = v
	return s
}

// SetTags sets the Tags field's value.
func (s *NodeConfigForCreateDefaultNodePoolInput) SetTags(v []*TagForCreateDefaultNodePoolInput) *NodeConfigForCreateDefaultNodePoolInput {
	s.Tags = v
	return s
}

type SecurityForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Login *LoginForCreateDefaultNodePoolInput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SecurityStrategies []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SecurityForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetLogin sets the Login field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetLogin(v *LoginForCreateDefaultNodePoolInput) *SecurityForCreateDefaultNodePoolInput {
	s.Login = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetSecurityGroupIds(v []*string) *SecurityForCreateDefaultNodePoolInput {
	s.SecurityGroupIds = v
	return s
}

// SetSecurityStrategies sets the SecurityStrategies field's value.
func (s *SecurityForCreateDefaultNodePoolInput) SetSecurityStrategies(v []*string) *SecurityForCreateDefaultNodePoolInput {
	s.SecurityStrategies = v
	return s
}

type TagForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateDefaultNodePoolInput) SetKey(v string) *TagForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateDefaultNodePoolInput) SetValue(v string) *TagForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

type TaintForCreateDefaultNodePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Effect *string `type:"string" json:",omitempty" enum:"EnumOfEffectForCreateDefaultNodePoolInput"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TaintForCreateDefaultNodePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaintForCreateDefaultNodePoolInput) GoString() string {
	return s.String()
}

// SetEffect sets the Effect field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetEffect(v string) *TaintForCreateDefaultNodePoolInput {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetKey(v string) *TaintForCreateDefaultNodePoolInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TaintForCreateDefaultNodePoolInput) SetValue(v string) *TaintForCreateDefaultNodePoolInput {
	s.Value = &v
	return s
}

const (
	// EnumOfEffectForCreateDefaultNodePoolInputNoSchedule is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputNoSchedule = "NoSchedule"

	// EnumOfEffectForCreateDefaultNodePoolInputPreferNoSchedule is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputPreferNoSchedule = "PreferNoSchedule"

	// EnumOfEffectForCreateDefaultNodePoolInputNoExecute is a EnumOfEffectForCreateDefaultNodePoolInput enum value
	EnumOfEffectForCreateDefaultNodePoolInputNoExecute = "NoExecute"
)

const (
	// EnumOfSecurityStrategyListForCreateDefaultNodePoolInputHids is a EnumOfSecurityStrategyListForCreateDefaultNodePoolInput enum value
	EnumOfSecurityStrategyListForCreateDefaultNodePoolInputHids = "Hids"
)
