// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateFileSystemCommon = "CreateFileSystem"

// CreateFileSystemCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFileSystemCommon operation. The "output" return
// value will be populated with the CreateFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFileSystemCommon Send returns without error.
//
// See CreateFileSystemCommon for more information on using the CreateFileSystemCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateFileSystemCommonRequest method.
//    req, resp := client.CreateFileSystemCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateFileSystemCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateFileSystemCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFileSystemCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateFileSystemCommon for usage and error information.
func (c *VEPFS) CreateFileSystemCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateFileSystemCommonRequest(input)
	return out, req.Send()
}

// CreateFileSystemCommonWithContext is the same as CreateFileSystemCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystemCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateFileSystemCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateFileSystemCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystem = "CreateFileSystem"

// CreateFileSystemRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateFileSystem operation. The "output" return
// value will be populated with the CreateFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateFileSystemCommon Send returns without error.
//
// See CreateFileSystem for more information on using the CreateFileSystem
// API call, and error handling.
//
//    // Example sending a request using the CreateFileSystemRequest method.
//    req, resp := client.CreateFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) CreateFileSystemRequest(input *CreateFileSystemInput) (req *request.Request, output *CreateFileSystemOutput) {
	op := &request.Operation{
		Name:       opCreateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFileSystemInput{}
	}

	output = &CreateFileSystemOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateFileSystem API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation CreateFileSystem for usage and error information.
func (c *VEPFS) CreateFileSystem(input *CreateFileSystemInput) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	return out, req.Send()
}

// CreateFileSystemWithContext is the same as CreateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) CreateFileSystemWithContext(ctx volcengine.Context, input *CreateFileSystemInput, opts ...request.Option) (*CreateFileSystemOutput, error) {
	req, out := c.CreateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateFileSystemInput struct {
	_ struct{} `type:"structure"`

	Capacity *int32 `type:"int32"`

	ChargeType *string `type:"string"`

	Description *string `type:"string"`

	FileSystemName *string `type:"string"`

	FileSystemType *string `type:"string"`

	Project *string `type:"string"`

	ProtocolType *string `type:"string"`

	StoreType *string `type:"string"`

	SubnetId *string `type:"string"`

	Tags []*TagForCreateFileSystemInput `type:"list"`

	VpcId *string `type:"string"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateFileSystemInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemInput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *CreateFileSystemInput) SetCapacity(v int32) *CreateFileSystemInput {
	s.Capacity = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateFileSystemInput) SetChargeType(v string) *CreateFileSystemInput {
	s.ChargeType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFileSystemInput) SetDescription(v string) *CreateFileSystemInput {
	s.Description = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CreateFileSystemInput) SetFileSystemName(v string) *CreateFileSystemInput {
	s.FileSystemName = &v
	return s
}

// SetFileSystemType sets the FileSystemType field's value.
func (s *CreateFileSystemInput) SetFileSystemType(v string) *CreateFileSystemInput {
	s.FileSystemType = &v
	return s
}

// SetProject sets the Project field's value.
func (s *CreateFileSystemInput) SetProject(v string) *CreateFileSystemInput {
	s.Project = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *CreateFileSystemInput) SetProtocolType(v string) *CreateFileSystemInput {
	s.ProtocolType = &v
	return s
}

// SetStoreType sets the StoreType field's value.
func (s *CreateFileSystemInput) SetStoreType(v string) *CreateFileSystemInput {
	s.StoreType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateFileSystemInput) SetSubnetId(v string) *CreateFileSystemInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemInput) SetTags(v []*TagForCreateFileSystemInput) *CreateFileSystemInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateFileSystemInput) SetVpcId(v string) *CreateFileSystemInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateFileSystemInput) SetZoneId(v string) *CreateFileSystemInput {
	s.ZoneId = &v
	return s
}

type CreateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	FileSystemId *string `type:"string"`

	OrderNO *string `type:"string"`

	Tags []*TagForCreateFileSystemOutput `type:"list"`
}

// String returns the string representation
func (s CreateFileSystemOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateFileSystemOutput) SetFileSystemId(v string) *CreateFileSystemOutput {
	s.FileSystemId = &v
	return s
}

// SetOrderNO sets the OrderNO field's value.
func (s *CreateFileSystemOutput) SetOrderNO(v string) *CreateFileSystemOutput {
	s.OrderNO = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemOutput) SetTags(v []*TagForCreateFileSystemOutput) *CreateFileSystemOutput {
	s.Tags = v
	return s
}

type TagForCreateFileSystemInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateFileSystemInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFileSystemInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFileSystemInput) SetKey(v string) *TagForCreateFileSystemInput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagForCreateFileSystemInput) SetType(v string) *TagForCreateFileSystemInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFileSystemInput) SetValue(v string) *TagForCreateFileSystemInput {
	s.Value = &v
	return s
}

type TagForCreateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateFileSystemOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateFileSystemOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateFileSystemOutput) SetKey(v string) *TagForCreateFileSystemOutput {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagForCreateFileSystemOutput) SetType(v string) *TagForCreateFileSystemOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateFileSystemOutput) SetValue(v string) *TagForCreateFileSystemOutput {
	s.Value = &v
	return s
}
