// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdspostgresql

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRestoreToNewInstanceCommon = "RestoreToNewInstance"

// RestoreToNewInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreToNewInstanceCommon operation. The "output" return
// value will be populated with the RestoreToNewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreToNewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreToNewInstanceCommon Send returns without error.
//
// See RestoreToNewInstanceCommon for more information on using the RestoreToNewInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the RestoreToNewInstanceCommonRequest method.
//    req, resp := client.RestoreToNewInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSPOSTGRESQL) RestoreToNewInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRestoreToNewInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreToNewInstanceCommon API operation for RDS_POSTGRESQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_POSTGRESQL's
// API operation RestoreToNewInstanceCommon for usage and error information.
func (c *RDSPOSTGRESQL) RestoreToNewInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RestoreToNewInstanceCommonRequest(input)
	return out, req.Send()
}

// RestoreToNewInstanceCommonWithContext is the same as RestoreToNewInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreToNewInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSPOSTGRESQL) RestoreToNewInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RestoreToNewInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreToNewInstance = "RestoreToNewInstance"

// RestoreToNewInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the RestoreToNewInstance operation. The "output" return
// value will be populated with the RestoreToNewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RestoreToNewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RestoreToNewInstanceCommon Send returns without error.
//
// See RestoreToNewInstance for more information on using the RestoreToNewInstance
// API call, and error handling.
//
//    // Example sending a request using the RestoreToNewInstanceRequest method.
//    req, resp := client.RestoreToNewInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSPOSTGRESQL) RestoreToNewInstanceRequest(input *RestoreToNewInstanceInput) (req *request.Request, output *RestoreToNewInstanceOutput) {
	op := &request.Operation{
		Name:       opRestoreToNewInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreToNewInstanceInput{}
	}

	output = &RestoreToNewInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RestoreToNewInstance API operation for RDS_POSTGRESQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_POSTGRESQL's
// API operation RestoreToNewInstance for usage and error information.
func (c *RDSPOSTGRESQL) RestoreToNewInstance(input *RestoreToNewInstanceInput) (*RestoreToNewInstanceOutput, error) {
	req, out := c.RestoreToNewInstanceRequest(input)
	return out, req.Send()
}

// RestoreToNewInstanceWithContext is the same as RestoreToNewInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreToNewInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSPOSTGRESQL) RestoreToNewInstanceWithContext(ctx volcengine.Context, input *RestoreToNewInstanceInput, opts ...request.Option) (*RestoreToNewInstanceOutput, error) {
	req, out := c.RestoreToNewInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ChargeInfoForRestoreToNewInstanceInput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	ChargeType *string `type:"string" enum:"EnumOfChargeTypeForRestoreToNewInstanceInput"`

	Number *int32 `type:"int32"`

	Period *int32 `type:"int32"`

	PeriodUnit *string `type:"string" enum:"EnumOfPeriodUnitForRestoreToNewInstanceInput"`
}

// String returns the string representation
func (s ChargeInfoForRestoreToNewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ChargeInfoForRestoreToNewInstanceInput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *ChargeInfoForRestoreToNewInstanceInput) SetAutoRenew(v bool) *ChargeInfoForRestoreToNewInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *ChargeInfoForRestoreToNewInstanceInput) SetChargeType(v string) *ChargeInfoForRestoreToNewInstanceInput {
	s.ChargeType = &v
	return s
}

// SetNumber sets the Number field's value.
func (s *ChargeInfoForRestoreToNewInstanceInput) SetNumber(v int32) *ChargeInfoForRestoreToNewInstanceInput {
	s.Number = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ChargeInfoForRestoreToNewInstanceInput) SetPeriod(v int32) *ChargeInfoForRestoreToNewInstanceInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *ChargeInfoForRestoreToNewInstanceInput) SetPeriodUnit(v string) *ChargeInfoForRestoreToNewInstanceInput {
	s.PeriodUnit = &v
	return s
}

type NodeInfoForRestoreToNewInstanceInput struct {
	_ struct{} `type:"structure"`

	NodeId *string `type:"string"`

	NodeOperateType *string `type:"string" enum:"EnumOfNodeOperateTypeForRestoreToNewInstanceInput"`

	NodeSpec *string `type:"string"`

	NodeType *string `type:"string" enum:"EnumOfNodeTypeForRestoreToNewInstanceInput"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s NodeInfoForRestoreToNewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeInfoForRestoreToNewInstanceInput) GoString() string {
	return s.String()
}

// SetNodeId sets the NodeId field's value.
func (s *NodeInfoForRestoreToNewInstanceInput) SetNodeId(v string) *NodeInfoForRestoreToNewInstanceInput {
	s.NodeId = &v
	return s
}

// SetNodeOperateType sets the NodeOperateType field's value.
func (s *NodeInfoForRestoreToNewInstanceInput) SetNodeOperateType(v string) *NodeInfoForRestoreToNewInstanceInput {
	s.NodeOperateType = &v
	return s
}

// SetNodeSpec sets the NodeSpec field's value.
func (s *NodeInfoForRestoreToNewInstanceInput) SetNodeSpec(v string) *NodeInfoForRestoreToNewInstanceInput {
	s.NodeSpec = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeInfoForRestoreToNewInstanceInput) SetNodeType(v string) *NodeInfoForRestoreToNewInstanceInput {
	s.NodeType = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeInfoForRestoreToNewInstanceInput) SetZoneId(v string) *NodeInfoForRestoreToNewInstanceInput {
	s.ZoneId = &v
	return s
}

type RestoreToNewInstanceInput struct {
	_ struct{} `type:"structure"`

	BackupId *string `type:"string"`

	ChargeInfo *ChargeInfoForRestoreToNewInstanceInput `type:"structure"`

	InstanceName *string `type:"string"`

	NodeInfo []*NodeInfoForRestoreToNewInstanceInput `type:"list"`

	ProjectName *string `type:"string"`

	RestoreTime *string `type:"string"`

	// SrcInstanceId is a required field
	SrcInstanceId *string `type:"string" required:"true"`

	StorageSpace *int32 `min:"20" max:"3000" type:"int32"`

	// StorageType is a required field
	StorageType *string `type:"string" required:"true" enum:"EnumOfStorageTypeForRestoreToNewInstanceInput"`

	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`

	Tags []*TagForRestoreToNewInstanceInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreToNewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreToNewInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreToNewInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreToNewInstanceInput"}
	if s.SrcInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SrcInstanceId"))
	}
	if s.StorageSpace != nil && *s.StorageSpace < 20 {
		invalidParams.Add(request.NewErrParamMinValue("StorageSpace", 20))
	}
	if s.StorageSpace != nil && *s.StorageSpace > 3000 {
		invalidParams.Add(request.NewErrParamMaxValue("StorageSpace", 3000))
	}
	if s.StorageType == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageType"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *RestoreToNewInstanceInput) SetBackupId(v string) *RestoreToNewInstanceInput {
	s.BackupId = &v
	return s
}

// SetChargeInfo sets the ChargeInfo field's value.
func (s *RestoreToNewInstanceInput) SetChargeInfo(v *ChargeInfoForRestoreToNewInstanceInput) *RestoreToNewInstanceInput {
	s.ChargeInfo = v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *RestoreToNewInstanceInput) SetInstanceName(v string) *RestoreToNewInstanceInput {
	s.InstanceName = &v
	return s
}

// SetNodeInfo sets the NodeInfo field's value.
func (s *RestoreToNewInstanceInput) SetNodeInfo(v []*NodeInfoForRestoreToNewInstanceInput) *RestoreToNewInstanceInput {
	s.NodeInfo = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *RestoreToNewInstanceInput) SetProjectName(v string) *RestoreToNewInstanceInput {
	s.ProjectName = &v
	return s
}

// SetRestoreTime sets the RestoreTime field's value.
func (s *RestoreToNewInstanceInput) SetRestoreTime(v string) *RestoreToNewInstanceInput {
	s.RestoreTime = &v
	return s
}

// SetSrcInstanceId sets the SrcInstanceId field's value.
func (s *RestoreToNewInstanceInput) SetSrcInstanceId(v string) *RestoreToNewInstanceInput {
	s.SrcInstanceId = &v
	return s
}

// SetStorageSpace sets the StorageSpace field's value.
func (s *RestoreToNewInstanceInput) SetStorageSpace(v int32) *RestoreToNewInstanceInput {
	s.StorageSpace = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *RestoreToNewInstanceInput) SetStorageType(v string) *RestoreToNewInstanceInput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *RestoreToNewInstanceInput) SetSubnetId(v string) *RestoreToNewInstanceInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreToNewInstanceInput) SetTags(v []*TagForRestoreToNewInstanceInput) *RestoreToNewInstanceInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *RestoreToNewInstanceInput) SetVpcId(v string) *RestoreToNewInstanceInput {
	s.VpcId = &v
	return s
}

type RestoreToNewInstanceOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string"`

	OrderId *string `type:"string"`
}

// String returns the string representation
func (s RestoreToNewInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreToNewInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *RestoreToNewInstanceOutput) SetInstanceId(v string) *RestoreToNewInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetOrderId sets the OrderId field's value.
func (s *RestoreToNewInstanceOutput) SetOrderId(v string) *RestoreToNewInstanceOutput {
	s.OrderId = &v
	return s
}

type TagForRestoreToNewInstanceInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForRestoreToNewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForRestoreToNewInstanceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForRestoreToNewInstanceInput) SetKey(v string) *TagForRestoreToNewInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForRestoreToNewInstanceInput) SetValue(v string) *TagForRestoreToNewInstanceInput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeTypeForRestoreToNewInstanceInputPostPaid is a EnumOfChargeTypeForRestoreToNewInstanceInput enum value
	EnumOfChargeTypeForRestoreToNewInstanceInputPostPaid = "PostPaid"

	// EnumOfChargeTypeForRestoreToNewInstanceInputPrePaid is a EnumOfChargeTypeForRestoreToNewInstanceInput enum value
	EnumOfChargeTypeForRestoreToNewInstanceInputPrePaid = "PrePaid"
)

const (
	// EnumOfNodeOperateTypeForRestoreToNewInstanceInputCreate is a EnumOfNodeOperateTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeOperateTypeForRestoreToNewInstanceInputCreate = "Create"

	// EnumOfNodeOperateTypeForRestoreToNewInstanceInputDelete is a EnumOfNodeOperateTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeOperateTypeForRestoreToNewInstanceInputDelete = "Delete"

	// EnumOfNodeOperateTypeForRestoreToNewInstanceInputModify is a EnumOfNodeOperateTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeOperateTypeForRestoreToNewInstanceInputModify = "Modify"
)

const (
	// EnumOfNodeTypeForRestoreToNewInstanceInputPrimary is a EnumOfNodeTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeTypeForRestoreToNewInstanceInputPrimary = "Primary"

	// EnumOfNodeTypeForRestoreToNewInstanceInputSecondary is a EnumOfNodeTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeTypeForRestoreToNewInstanceInputSecondary = "Secondary"

	// EnumOfNodeTypeForRestoreToNewInstanceInputReadOnly is a EnumOfNodeTypeForRestoreToNewInstanceInput enum value
	EnumOfNodeTypeForRestoreToNewInstanceInputReadOnly = "ReadOnly"
)

const (
	// EnumOfPeriodUnitForRestoreToNewInstanceInputMonth is a EnumOfPeriodUnitForRestoreToNewInstanceInput enum value
	EnumOfPeriodUnitForRestoreToNewInstanceInputMonth = "Month"

	// EnumOfPeriodUnitForRestoreToNewInstanceInputYear is a EnumOfPeriodUnitForRestoreToNewInstanceInput enum value
	EnumOfPeriodUnitForRestoreToNewInstanceInputYear = "Year"
)

const (
	// EnumOfStorageTypeForRestoreToNewInstanceInputLocalSsd is a EnumOfStorageTypeForRestoreToNewInstanceInput enum value
	EnumOfStorageTypeForRestoreToNewInstanceInputLocalSsd = "LocalSSD"
)
