// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opSetSecretValueCommon = "SetSecretValue"

// SetSecretValueCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the SetSecretValueCommon operation. The "output" return
// value will be populated with the SetSecretValueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SetSecretValueCommon Request to send the API call to the service.
// the "output" return value is not valid until after SetSecretValueCommon Send returns without error.
//
// See SetSecretValueCommon for more information on using the SetSecretValueCommon
// API call, and error handling.
//
//    // Example sending a request using the SetSecretValueCommonRequest method.
//    req, resp := client.SetSecretValueCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) SetSecretValueCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opSetSecretValueCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SetSecretValueCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation SetSecretValueCommon for usage and error information.
func (c *KMS) SetSecretValueCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.SetSecretValueCommonRequest(input)
	return out, req.Send()
}

// SetSecretValueCommonWithContext is the same as SetSecretValueCommon with the addition of
// the ability to pass a context and additional request options.
//
// See SetSecretValueCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) SetSecretValueCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.SetSecretValueCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetSecretValue = "SetSecretValue"

// SetSecretValueRequest generates a "volcengine/request.Request" representing the
// client's request for the SetSecretValue operation. The "output" return
// value will be populated with the SetSecretValueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SetSecretValueCommon Request to send the API call to the service.
// the "output" return value is not valid until after SetSecretValueCommon Send returns without error.
//
// See SetSecretValue for more information on using the SetSecretValue
// API call, and error handling.
//
//    // Example sending a request using the SetSecretValueRequest method.
//    req, resp := client.SetSecretValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) SetSecretValueRequest(input *SetSecretValueInput) (req *request.Request, output *SetSecretValueOutput) {
	op := &request.Operation{
		Name:       opSetSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSecretValueInput{}
	}

	output = &SetSecretValueOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SetSecretValue API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation SetSecretValue for usage and error information.
func (c *KMS) SetSecretValue(input *SetSecretValueInput) (*SetSecretValueOutput, error) {
	req, out := c.SetSecretValueRequest(input)
	return out, req.Send()
}

// SetSecretValueWithContext is the same as SetSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See SetSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) SetSecretValueWithContext(ctx volcengine.Context, input *SetSecretValueInput, opts ...request.Option) (*SetSecretValueOutput, error) {
	req, out := c.SetSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type SetSecretValueInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`

	// SecretValue is a required field
	SecretValue *string `max:"30720" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s SetSecretValueInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSecretValueInput"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 31, *s.SecretName))
	}
	if s.SecretValue == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretValue"))
	}
	if s.SecretValue != nil && len(*s.SecretValue) > 30720 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretValue", 30720, *s.SecretValue))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *SetSecretValueInput) SetSecretName(v string) *SetSecretValueInput {
	s.SecretName = &v
	return s
}

// SetSecretValue sets the SecretValue field's value.
func (s *SetSecretValueInput) SetSecretValue(v string) *SetSecretValueInput {
	s.SecretValue = &v
	return s
}

type SetSecretValueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreationDate *int64 `type:"int64" json:",omitempty"`

	VersionID *string `type:"string" json:",omitempty"`

	VersionStage *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SetSecretValueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSecretValueOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SetSecretValueOutput) SetCreationDate(v int64) *SetSecretValueOutput {
	s.CreationDate = &v
	return s
}

// SetVersionID sets the VersionID field's value.
func (s *SetSecretValueOutput) SetVersionID(v string) *SetSecretValueOutput {
	s.VersionID = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *SetSecretValueOutput) SetVersionStage(v string) *SetSecretValueOutput {
	s.VersionStage = &v
	return s
}
