// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opClonePublicWorkspaceCommon = "ClonePublicWorkspace"

// ClonePublicWorkspaceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ClonePublicWorkspaceCommon operation. The "output" return
// value will be populated with the ClonePublicWorkspaceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ClonePublicWorkspaceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ClonePublicWorkspaceCommon Send returns without error.
//
// See ClonePublicWorkspaceCommon for more information on using the ClonePublicWorkspaceCommon
// API call, and error handling.
//
//    // Example sending a request using the ClonePublicWorkspaceCommonRequest method.
//    req, resp := client.ClonePublicWorkspaceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ClonePublicWorkspaceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opClonePublicWorkspaceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ClonePublicWorkspaceCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ClonePublicWorkspaceCommon for usage and error information.
func (c *BIO) ClonePublicWorkspaceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ClonePublicWorkspaceCommonRequest(input)
	return out, req.Send()
}

// ClonePublicWorkspaceCommonWithContext is the same as ClonePublicWorkspaceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ClonePublicWorkspaceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ClonePublicWorkspaceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ClonePublicWorkspaceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClonePublicWorkspace = "ClonePublicWorkspace"

// ClonePublicWorkspaceRequest generates a "volcengine/request.Request" representing the
// client's request for the ClonePublicWorkspace operation. The "output" return
// value will be populated with the ClonePublicWorkspaceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ClonePublicWorkspaceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ClonePublicWorkspaceCommon Send returns without error.
//
// See ClonePublicWorkspace for more information on using the ClonePublicWorkspace
// API call, and error handling.
//
//    // Example sending a request using the ClonePublicWorkspaceRequest method.
//    req, resp := client.ClonePublicWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ClonePublicWorkspaceRequest(input *ClonePublicWorkspaceInput) (req *request.Request, output *ClonePublicWorkspaceOutput) {
	op := &request.Operation{
		Name:       opClonePublicWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClonePublicWorkspaceInput{}
	}

	output = &ClonePublicWorkspaceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ClonePublicWorkspace API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ClonePublicWorkspace for usage and error information.
func (c *BIO) ClonePublicWorkspace(input *ClonePublicWorkspaceInput) (*ClonePublicWorkspaceOutput, error) {
	req, out := c.ClonePublicWorkspaceRequest(input)
	return out, req.Send()
}

// ClonePublicWorkspaceWithContext is the same as ClonePublicWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See ClonePublicWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ClonePublicWorkspaceWithContext(ctx volcengine.Context, input *ClonePublicWorkspaceInput, opts ...request.Option) (*ClonePublicWorkspaceOutput, error) {
	req, out := c.ClonePublicWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ClonePublicWorkspaceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CoverPath *string `type:"string" json:",omitempty"`

	// Description is a required field
	Description *string `min:"1" max:"1000" type:"string" json:",omitempty" required:"true"`

	Labels []*string `type:"list" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"200" type:"string" json:",omitempty" required:"true"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ClonePublicWorkspaceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ClonePublicWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClonePublicWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClonePublicWorkspaceInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 1000 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 1000, *s.Description))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCoverPath sets the CoverPath field's value.
func (s *ClonePublicWorkspaceInput) SetCoverPath(v string) *ClonePublicWorkspaceInput {
	s.CoverPath = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClonePublicWorkspaceInput) SetDescription(v string) *ClonePublicWorkspaceInput {
	s.Description = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ClonePublicWorkspaceInput) SetLabels(v []*string) *ClonePublicWorkspaceInput {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *ClonePublicWorkspaceInput) SetName(v string) *ClonePublicWorkspaceInput {
	s.Name = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ClonePublicWorkspaceInput) SetWorkspaceID(v string) *ClonePublicWorkspaceInput {
	s.WorkspaceID = &v
	return s
}

type ClonePublicWorkspaceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ClonePublicWorkspaceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ClonePublicWorkspaceOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *ClonePublicWorkspaceOutput) SetID(v string) *ClonePublicWorkspaceOutput {
	s.ID = &v
	return s
}
