// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package billing

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCancelInvitationCommon = "CancelInvitation"

// CancelInvitationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CancelInvitationCommon operation. The "output" return
// value will be populated with the CancelInvitationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CancelInvitationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CancelInvitationCommon Send returns without error.
//
// See CancelInvitationCommon for more information on using the CancelInvitationCommon
// API call, and error handling.
//
//    // Example sending a request using the CancelInvitationCommonRequest method.
//    req, resp := client.CancelInvitationCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BILLING) CancelInvitationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCancelInvitationCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CancelInvitationCommon API operation for BILLING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BILLING's
// API operation CancelInvitationCommon for usage and error information.
func (c *BILLING) CancelInvitationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CancelInvitationCommonRequest(input)
	return out, req.Send()
}

// CancelInvitationCommonWithContext is the same as CancelInvitationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CancelInvitationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BILLING) CancelInvitationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CancelInvitationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelInvitation = "CancelInvitation"

// CancelInvitationRequest generates a "volcengine/request.Request" representing the
// client's request for the CancelInvitation operation. The "output" return
// value will be populated with the CancelInvitationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CancelInvitationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CancelInvitationCommon Send returns without error.
//
// See CancelInvitation for more information on using the CancelInvitation
// API call, and error handling.
//
//    // Example sending a request using the CancelInvitationRequest method.
//    req, resp := client.CancelInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BILLING) CancelInvitationRequest(input *CancelInvitationInput) (req *request.Request, output *CancelInvitationOutput) {
	op := &request.Operation{
		Name:       opCancelInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelInvitationInput{}
	}

	output = &CancelInvitationOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CancelInvitation API operation for BILLING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BILLING's
// API operation CancelInvitation for usage and error information.
func (c *BILLING) CancelInvitation(input *CancelInvitationInput) (*CancelInvitationOutput, error) {
	req, out := c.CancelInvitationRequest(input)
	return out, req.Send()
}

// CancelInvitationWithContext is the same as CancelInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See CancelInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BILLING) CancelInvitationWithContext(ctx volcengine.Context, input *CancelInvitationInput, opts ...request.Option) (*CancelInvitationOutput, error) {
	req, out := c.CancelInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CancelInvitationInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AuthID *string `type:"string" json:",omitempty"`

	// InvitationType is a required field
	InvitationType *int32 `type:"int32" json:",omitempty" required:"true"`

	Relation *int32 `type:"int32" json:",omitempty"`

	// RelationID is a required field
	RelationID *string `type:"string" json:",omitempty" required:"true"`

	SubAccountID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CancelInvitationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelInvitationInput"}
	if s.InvitationType == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationType"))
	}
	if s.RelationID == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthID sets the AuthID field's value.
func (s *CancelInvitationInput) SetAuthID(v string) *CancelInvitationInput {
	s.AuthID = &v
	return s
}

// SetInvitationType sets the InvitationType field's value.
func (s *CancelInvitationInput) SetInvitationType(v int32) *CancelInvitationInput {
	s.InvitationType = &v
	return s
}

// SetRelation sets the Relation field's value.
func (s *CancelInvitationInput) SetRelation(v int32) *CancelInvitationInput {
	s.Relation = &v
	return s
}

// SetRelationID sets the RelationID field's value.
func (s *CancelInvitationInput) SetRelationID(v string) *CancelInvitationInput {
	s.RelationID = &v
	return s
}

// SetSubAccountID sets the SubAccountID field's value.
func (s *CancelInvitationInput) SetSubAccountID(v int64) *CancelInvitationInput {
	s.SubAccountID = &v
	return s
}

type CancelInvitationOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	IsSuccess *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CancelInvitationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelInvitationOutput) GoString() string {
	return s.String()
}

// SetIsSuccess sets the IsSuccess field's value.
func (s *CancelInvitationOutput) SetIsSuccess(v bool) *CancelInvitationOutput {
	s.IsSuccess = &v
	return s
}
