# developing
- [Fix issue 4961, `leafInfo.match()` use `path.join()` to deal with `wildcardValues`, which may lead to cross directory risk ](https://github.com/beego/beego/pull/4964)

# v2.1.2
- [refactor: CONTRIBUTING.md file grammatical improvements](https://github.com/beego/beego/issues/5411)
- [fix: refactor Count method](https://github.com/beego/beego/pull/5300)
- [support db_type in ddl ](https://github.com/beego/beego/pull/5404)
- [orm: PostgreSQL change auto to bigserial](https://github.com/beego/beego/pull/5415)

# v2.1.1
- [httplib: fix unstable unit test which use the httplib.org](https://github.com/beego/beego/pull/5232)
- [rft: remove adapter package](https://github.com/beego/beego/pull/5239)
- [feat: add write-delete cache mode](https://github.com/beego/beego/pull/5242)
- [feat: add write-double-delete cache mode](https://github.com/beego/beego/pull/5243)
- [fix 5255: Check the rows.Err() if rows.Next() is false](https://github.com/beego/beego/pull/5256)
- [orm: missing handling %COL% placeholder](https://github.com/beego/beego/pull/5257)
- [fix: use of ioutil package](https://github.com/beego/beego/pull/5261)
- [cache/redis: support skipEmptyPrefix option ](https://github.com/beego/beego/pull/5264)
- [fix: refactor InsertValue method](https://github.com/beego/beego/pull/5267)
- [fix: modify InsertOrUpdate method, Remove the isMulti variable and its associated code](https://github.com/beego/beego/pull/5269)
- [refactor cache/redis: Use redisConfig to receive incoming JSON (previously using a map)](https://github.com/beego/beego/pull/5268)
- [fix: refactor DeleteSQL method](https://github.com/beego/beego/pull/5271)
- [fix: refactor UpdateSQL method](https://github.com/beego/beego/pull/5274)
- [fix: refactor UpdateBatch method](https://github.com/beego/beego/pull/5295)
- [fix: refactor InsertOrUpdate method](https://github.com/beego/beego/pull/5296)
- [fix: refactor ReadBatch method](https://github.com/beego/beego/pull/5298)
- [fix: refactor ReadValues method](https://github.com/beego/beego/pull/5303)

## ORM refactoring
- [introducing internal/models pkg](https://github.com/beego/beego/pull/5238)

# v2.1.0
- [unified gopkg.in/yaml version to v2](https://github.com/beego/beego/pull/5169)
- [add non-block write log in asynchronous mode](https://github.com/beego/beego/pull/5150)
- [Fix 5126: support bloom filter cache](https://github.com/beego/beego/pull/5126)
- [Fix 5117: support write though cache](https://github.com/beego/beego/pull/5117)
- [add read through for cache module](https://github.com/beego/beego/pull/5116)
- [add singleflight cache for cache module](https://github.com/beego/beego/pull/5119)
- [Fix 5129: must set formatter after init the logger](https://github.com/beego/beego/pull/5130)
- [Fix 5079: only log msg when the channel is not closed](https://github.com/beego/beego/pull/5132)
- [Fix 4435: Controller SaveToFile remove all temp file](https://github.com/beego/beego/pull/5138)
- [Fix 5079: Split signalChan into flushChan and closeChan](https://github.com/beego/beego/pull/5139)
- [Fix 5172: protect field access with lock to avoid possible data race](https://github.com/beego/beego/pull/5210)
- [cache: fix typo and optimize the naming]()
- [Fix 5176: beegoAppConfig String and Strings function has bug](https://github.com/beego/beego/pull/5211)

# v2.1.0
- [unified gopkg.in/yaml version to v2](https://github.com/beego/beego/pull/5169)
- [add non-block write log in asynchronous mode](https://github.com/beego/beego/pull/5150)
- [Fix 5126: support bloom filter cache](https://github.com/beego/beego/pull/5126)
- [Fix 5117: support write though cache](https://github.com/beego/beego/pull/5117)
- [add read through for cache module](https://github.com/beego/beego/pull/5116)
- [add singleflight cache for cache module](https://github.com/beego/beego/pull/5119)
- [Fix 5129: must set formatter after init the logger](https://github.com/beego/beego/pull/5130)
- [Fix 5079: only log msg when the channel is not closed](https://github.com/beego/beego/pull/5132)
- [Fix 4435: Controller SaveToFile remove all temp file](https://github.com/beego/beego/pull/5138)
- [Fix 5079: Split signalChan into flushChan and closeChan](https://github.com/beego/beego/pull/5139)
- [Fix 5172: protect field access with lock to avoid possible data race](https://github.com/beego/beego/pull/5210)
- [cache: fix typo and optimize the naming]()

# v2.0.7
- [Upgrade github.com/go-kit/kit, CVE-2022-24450](https://github.com/beego/beego/pull/5121)
# v2.0.6
- [fix: revise the body wrapper to handle empty body case](https://github.com/beego/beego/pull/5102)

# v2.0.5

Note: now we force the web admin service serving HTTP only.

- [Fix 4984: random expire cache](https://github.com/beego/beego/pull/4984)
- [Fix 4907: make admin serve HTTP only](https://github.com/beego/beego/pull/5005)
- [Feat 4999: add get all tasks function](https://github.com/beego/beego/pull/4999)
- [Fix 5012: fix some bug, pass []any as any in variadic function](https://github.com/beego/beego/pull/5012)
- [Fix 5022: Miss assigning listener to graceful Server](https://github.com/beego/beego/pull/5028)
- [Fix 4955: Make commands and Docker compose for ORM unit tests](https://github.com/beego/beego/pull/5031)

# v2.0.4

Note: now we force the web admin service serving HTTP only.

- [Fix issue 4961, `leafInfo.match()` use `path.join()` to deal with `wildcardValues`, which may lead to cross directory risk ](https://github.com/beego/beego/pull/4964)
- [Fix 4975: graceful server listen the specific address](https://github.com/beego/beego/pull/4979)
- [Fix 4976: make admin serve HTTP only](https://github.com/beego/beego/pull/4980)

# v2.0.3
- [upgrade redisgo to v1.8.8](https://github.com/beego/beego/pull/4872)
- [fix prometheus CVE-2022-21698](https://github.com/beego/beego/pull/4878)
- [upgrade to Go 1.18](https://github.com/beego/beego/pull/4896)
- [make `PatternLogFormatter` handling the arguments](https://github.com/beego/beego/pull/4914/files)
- [Add httplib OpenTelemetry Filter](https://github.com/beego/beego/pull/4888, https://github.com/beego/beego/pull/4915)
- [Add orm OpenTelemetry Filter](https://github.com/beego/beego/issues/4944)
- [Support NewBeegoRequestWithCtx in httplib](https://github.com/beego/beego/pull/4895)
- [Support lifecycle callback](https://github.com/beego/beego/pull/4918)
- [Append column comments to create table sentence when using postgres](https://github.com/beego/beego/pull/4940)
- [logs: multiFileLogWriter uses incorrect formatter](https://github.com/beego/beego/pull/4943)
- [fix issue 4946 CVE-2022-31259](https://github.com/beego/beego/pull/4954)

# v2.0.2
See v2.0.2-beta.1
- [fix bug: etcd should use etcd as adapter name](https://github.com/beego/beego/pull/4845)
# v2.0.2-beta.1
- Add a custom option for whether to escape HTML special characters when processing http request parameters. [4701](https://github.com/beego/beego/pull/4701)
- Always set the response status in the CustomAbort function. [4686](https://github.com/beego/beego/pull/4686)
- Add template functions eq,lt to support uint and int compare. [4607](https://github.com/beego/beego/pull/4607)
- Migrate tests to GitHub Actions. [4663](https://github.com/beego/beego/issues/4663)
- Add http client and option func. [4455](https://github.com/beego/beego/issues/4455)
- Add: Convenient way to generate mock object [4620](https://github.com/beego/beego/issues/4620)
- Infra: use dependabot to update dependencies. [4623](https://github.com/beego/beego/pull/4623)
- Lint: use golangci-lint. [4619](https://github.com/beego/beego/pull/4619)
- Chore: format code. [4615](https://github.com/beego/beego/pull/4615)
- Test on Go v1.15.x & v1.16.x. [4614](https://github.com/beego/beego/pull/4614)
- Env: non-empty GOBIN & GOPATH. [4613](https://github.com/beego/beego/pull/4613)
- Chore: update dependencies. [4611](https://github.com/beego/beego/pull/4611)
- Update orm_test.go/TestInsertOrUpdate with table-driven. [4609](https://github.com/beego/beego/pull/4609)
- Add: Resp() method for web.Controller. [4588](https://github.com/beego/beego/pull/4588)
- Web mock and test support. [4565](https://github.com/beego/beego/pull/4565) [4574](https://github.com/beego/beego/pull/4574)
- Error codes definition of cache module. [4493](https://github.com/beego/beego/pull/4493)
- Remove generateCommentRoute http hook. Using `bee generate routers` commands instead.[4486](https://github.com/beego/beego/pull/4486) [bee PR 762](https://github.com/beego/bee/pull/762)
- Fix: /abc.html/aaa match /abc/aaa. [4459](https://github.com/beego/beego/pull/4459)
- ORM mock. [4407](https://github.com/beego/beego/pull/4407)
- Add sonar check and ignore test. [4432](https://github.com/beego/beego/pull/4432) [4433](https://github.com/beego/beego/pull/4433)
- Update changlog.yml to check every PR to develop branch.[4427](https://github.com/beego/beego/pull/4427)
- Fix 4396: Add context.param module into adapter. [4398](https://github.com/beego/beego/pull/4398)
- Support `RollbackUnlessCommit` API. [4542](https://github.com/beego/beego/pull/4542)
- Fix 4503 and 4504: Add `when` to `Write([]byte)` method and add `prefix` to `writeMsg`. [4507](https://github.com/beego/beego/pull/4507)
- Fix 4480: log format incorrect. [4482](https://github.com/beego/beego/pull/4482)
- Remove `duration` from prometheus labels. [4391](https://github.com/beego/beego/pull/4391)
- Fix `unknown escape sequence` in generated code. [4385](https://github.com/beego/beego/pull/4385)
- Fix 4590: Forget to check URL when FilterChain invoke `next()`. [4593](https://github.com/beego/beego/pull/4593)
- Fix 4727: CSS when request URI is invalid. [4729](https://github.com/beego/beego/pull/4729)
- Using fixed name `commentRouter.go` as generated file name. [4385](https://github.com/beego/beego/pull/4385)
- Fix 4383: ORM Adapter produces panic when using orm.RegisterModelWithPrefix. [4386](https://github.com/beego/beego/pull/4386)
- Support 4144: Add new api for order by for supporting multiple way to query [4294](https://github.com/beego/beego/pull/4294)
- Support session Filter chain. [4404](https://github.com/beego/beego/pull/4404)
- Feature issue #4402 finish router get example. [4416](https://github.com/beego/beego/pull/4416)
- Implement context.Context support and deprecate `QueryM2MWithCtx` and `QueryTableWithCtx` [4424](https://github.com/beego/beego/pull/4424)
- Finish timeout option for tasks #4441 [4441](https://github.com/beego/beego/pull/4441)
- Error Module brief design & using httplib module to validate this design. [4453](https://github.com/beego/beego/pull/4453)
- Fix 4444: panic when 404 not found. [4446](https://github.com/beego/beego/pull/4446)
- Fix 4435: fix panic when controller dir not found. [4452](https://github.com/beego/beego/pull/4452)
- Hotfix:reflect.ValueOf(nil) in getFlatParams [4716](https://github.com/beego/beego/issues/4716)
- Fix 4456: Fix router method expression [4456](https://github.com/beego/beego/pull/4456)
- Remove some `go get` lines in `.travis.yml` file [4469](https://github.com/beego/beego/pull/4469)
- Fix 4451: support QueryExecutor interface. [4461](https://github.com/beego/beego/pull/4461)
- Add some testing scripts [4461](https://github.com/beego/beego/pull/4461)
- Refactor httplib: Move debug code to a filter [4440](https://github.com/beego/beego/issues/4440)
- fix: code quality issues [4513](https://github.com/beego/beego/pull/4513)
- Optimize maligned structs to reduce memory foot-print [4525](https://github.com/beego/beego/pull/4525)
- Feat: add token bucket ratelimit filter [4508](https://github.com/beego/beego/pull/4508)
- Improve: Avoid ignoring mistakes that need attention [4548](https://github.com/beego/beego/pull/4548)
- Integration: DeepSource [4560](https://github.com/beego/beego/pull/4560)
- Integration: Remove unnecessary function call [4577](https://github.com/beego/beego/pull/4577)
- Feature issue #4402 finish router get example. [4416](https://github.com/beego/beego/pull/4416)
- Proposal: Add Bind() method for `web.Controller` [4491](https://github.com/beego/beego/issues/4579)
- Optimize AddAutoPrefix: only register one router in case-insensitive mode. [4582](https://github.com/beego/beego/pull/4582)
- Init exceptMethod by using reflection. [4583](https://github.com/beego/beego/pull/4583)
- Deprecated BeeMap and replace all usage with `sync.map` [4616](https://github.com/beego/beego/pull/4616)
- TaskManager support graceful shutdown [4635](https://github.com/beego/beego/pull/4635)
- Add comments to `web.Config`, rename `RouterXXX` to `CtrlXXX`, define `HandleFunc` [4714](https://github.com/beego/beego/pull/4714)
- Refactor: Move `BindXXX` and `XXXResp` methods to `context.Context`. [4718](https://github.com/beego/beego/pull/4718)
- Fix 4728: Print wrong file name. [4737](https://github.com/beego/beego/pull/4737)
- fix bug:reflect.ValueOf(nil) in getFlatParams [4715](https://github.com/beego/beego/pull/4715)
- Fix 4736: set a fixed value "/" to the "Path" of "_xsrf" cookie. [4736](https://github.com/beego/beego/issues/4735) [4739](https://github.com/beego/beego/issues/4739)
- Fix 4734: do not reset id in Delete function. [4738](https://github.com/beego/beego/pull/4738) [4742](https://github.com/beego/beego/pull/4742)
- Fix 4699: Remove Remove goyaml2 dependency. [4755](https://github.com/beego/beego/pull/4755)
- Fix 4698: Prompt error when config format is incorrect. [4757](https://github.com/beego/beego/pull/4757)
- Fix 4674: Tx Orm missing debug log [4756](https://github.com/beego/beego/pull/4756)
- Fix 4759: fix numeric notation of permissions [4759](https://github.com/beego/beego/pull/4759)
- set default rate and capacity for ratelimit filter [4796](https://github.com/beego/beego/pull/4796)
- Fix 4782: must set status before rendering error page [4797](https://github.com/beego/beego/pull/4797)
- Fix 4791: delay to format parameter in log module [4804](https://github.com/beego/beego/pull/4804)

## Fix Sonar

- [4677](https://github.com/beego/beego/pull/4677)
- [4624](https://github.com/beego/beego/pull/4624)
- [4608](https://github.com/beego/beego/pull/4608)
- [4473](https://github.com/beego/beego/pull/4473)
- [4474](https://github.com/beego/beego/pull/4474)
- [4479](https://github.com/beego/beego/pull/4479)
- [4639](https://github.com/beego/beego/pull/4639)
- [4668](https://github.com/beego/beego/pull/4668)

## Fix lint and format code

- [4644](https://github.com/beego/beego/pull/4644)
- [4645](https://github.com/beego/beego/pull/4645)
- [4646](https://github.com/beego/beego/pull/4646)
- [4647](https://github.com/beego/beego/pull/4647)
- [4648](https://github.com/beego/beego/pull/4648)
- [4649](https://github.com/beego/beego/pull/4649)
- [4651](https://github.com/beego/beego/pull/4651)
- [4652](https://github.com/beego/beego/pull/4652)
- [4653](https://github.com/beego/beego/pull/4653)
- [4654](https://github.com/beego/beego/pull/4654)
- [4655](https://github.com/beego/beego/pull/4655)
- [4656](https://github.com/beego/beego/pull/4656)
- [4660](https://github.com/beego/beego/pull/4660)
