# Copyright Project Harbor Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#	http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License

*** Settings ***
Documentation  This resource provides any keywords related to the Harbor private registry appliance

*** Variables ***
${vulnerability_edit_btn}  xpath=//vulnerability-config//cron-selection//button[contains(.,'EDIT')]
${vulnerability_dropdown_list}  xpath=//vulnerability-config//cron-selection//select[@id='selectPolicy']
${vulnerability_dropdown_list_item_none}  xpath=//select[@id='selectPolicy']//option[contains(.,'None')]
${vulnerability_dropdown_list_item_custom}  xpath=//select[@id='selectPolicy']//option[contains(.,'Custom')]
${vulnerability_save_btn}  xpath=//cron-selection//button[contains(.,'SAVE')]
${scan_now_button}  //vulnerability-config//button[contains(.,'NOW')]
${stop_scan_button}  //vulnerability-config//button[contains(.,'Stop Scan')]
${vulnerability_page}  //clr-vertical-nav-group-children/a[contains(.,'Vulnerability')]
${set_default_scanner}  //button[@id='set-default']
${scanner_action_xpath}  //span[@id='action-scanner']
${edit_scanner_action_xpath}  //span[text()='EDIT']
${delete_scanner_action_xpath}  //span[@id='delete-scanner-action']
${immutable_trivy_msg_xpath}  //span[contains(.,'registration Trivy is not allowed to delete as it is immutable: scanner API: delete')]
${delete_scanner_confirm_btn}  xpath=//clr-modal//button[contains(.,'DELETE')]
${scan_now_result}  xpath=//div[@id="scan-result-container"]
${scanner_set_default}  xpath=//button[@id="set-default"]
${scanner_set_default_success_xpath}  //span[contains(.,'Successfully updated')]
${not_scanned_icon}  xpath=//span[@class[contains(.,'not-scan')]]
${stopped_icon}  //span[@class[contains(.,'badge abort')]]
${view_scanner_icon_xpath}  //clr-signpost//cds-icon
${view_scanner_doc_xpath}  //clr-signpost-content//a[contains(.,'view documentation')]
${add_scanner_btn}  //button[text()=' NEW SCANNER ']
${scanner_name_input}  //*[@id='scanner-name']
${scanner_desc_input}  //*[@id='description']
${scanner_endpoint_input}  //*[@id='scanner-endpoint']
${scanner_skip_cert_checkbox}  //label[contains(@class,'clr-control-label') and contains(@for,'scanner-skipCertVerify')]
${scanner_test_connection_btn}  //*[@id='button-test']
${scanner_add_btn}  //span[text()=' ADD ']
${scanner_save_btn}  //span[text()=' SAVE ']
${scanner_auth_select}  //*[@id='scanner-authorization']
${scanner_username_input}  //*[@id='scanner-username']
${scanner_password_input}  //*[@id='scanner-password']
${scanner_token_input}  //*[@id='scanner-token']
${scanner_apikey_input}  //*[@id='scanner-apiKey']
${scanner_set_default_btn}  //*[@id='set-default']
${scanner_list_refresh_btn}  //span[@class='refresh-btn']//clr-icon[@role='none']
