// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package security

import (
	"net/http"
	"os"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"github.com/goharbor/harbor/src/common/security"
	"github.com/goharbor/harbor/src/common/utils/test"
)

func TestMain(m *testing.M) {
	test.InitDatabaseFromEnv()
	os.Exit(m.Run())
}

func TestSecurity(t *testing.T) {
	var ctx security.Context
	var exist bool
	generators = []generator{&unauthorized{}}
	handler := http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx, exist = security.FromContext(r.Context())
	})
	req, err := http.NewRequest("POST", "http://127.0.0.1:8080/api/users", nil)
	require.Nil(t, err)
	Middleware()(handler).ServeHTTP(nil, req)
	require.True(t, exist)
	assert.NotNil(t, ctx)
}
