// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package mergeslash

import (
	"net/http"
	"regexp"

	"github.com/goharbor/harbor/src/server/middleware"
)

var multiSlash = regexp.MustCompile(`(/+)`)

// Middleware creates the middleware to merge slashes in the URL path of the request
func Middleware(skippers ...middleware.Skipper) func(http.Handler) http.Handler {
	return middleware.New(func(w http.ResponseWriter, r *http.Request, next http.Handler) {
		path := multiSlash.ReplaceAll([]byte(r.URL.Path), []byte("/"))
		r.URL.Path = string(path)
		next.ServeHTTP(w, r)
	}, skippers...)
}
