// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import { ComponentFixture, TestBed } from '@angular/core/testing';
import { VulnerabilitySummaryComponent } from './vulnerability-summary.component';
import { SharedTestingModule } from '../../../../../shared/shared.module';
import { SecurityhubService } from '../../../../../../../ng-swagger-gen/services/securityhub.service';
import { of } from 'rxjs';
import { delay } from 'rxjs/operators';
import { SecuritySummary } from '../../../../../../../ng-swagger-gen/models/security-summary';
import { NO_ERRORS_SCHEMA } from '@angular/core';

describe('VulnerabilitySummaryComponent', () => {
    let component: VulnerabilitySummaryComponent;
    let fixture: ComponentFixture<VulnerabilitySummaryComponent>;

    const mockedSummary: SecuritySummary = {
        critical_cnt: 323,
        dangerous_artifacts: [
            {
                critical_cnt: 124,
                digest: 'sha256:7027e69a2172e38cef8ac2cb1f046025895c9fcf3160e8f70ffb26446f680e4d',
                high_cnt: 903,
                medium_cnt: 861,
                project_id: 1,
                repository_name: 'library/nuxeo',
            },
            {
                critical_cnt: 124,
                digest: 'sha256:7027e69a2172e38cef8ac2cb1f046025895c9fcf3160e8f70ffb26446f680e4d',
                high_cnt: 903,
                medium_cnt: 861,
                project_id: 11,
                repository_name: 'sample/nuxeo',
            },
            {
                critical_cnt: 64,
                digest: 'sha256:b7b209fce05e70ccd2e0358114264355cd7df0dd464bb5b23ac41b6215653a22',
                high_cnt: 149,
                medium_cnt: 147,
                project_id: 1,
                repository_name: 'library/openldap',
            },
            {
                critical_cnt: 8,
                digest: 'sha256:c7c1c56aab2d5b0f1470ec90d7113665ed577d6952b48b88f556e3448a9a4175',
                high_cnt: 104,
                medium_cnt: 80,
                project_id: 1,
                repository_name: 'library/spectral',
            },
            {
                critical_cnt: 3,
                digest: 'sha256:a97a153152fcd6410bdf4fb64f5622ecf97a753f07dcc89dab14509d059736cf',
                high_cnt: 31,
                medium_cnt: 28,
                project_id: 1,
                repository_name: 'library/nuxeo',
            },
        ],
        dangerous_cves: [
            {
                cve_id: 'CVE-2021-44228',
                cvss_score_v3: 10,
                package: 'org.apache.logging.log4j:log4j-core',
                severity: 'Critical',
                version: '2.11.1',
            },
            {
                cve_id: 'CVE-2021-21345',
                cvss_score_v3: 9.9,
                package: 'com.thoughtworks.xstream:xstream',
                severity: 'Critical',
                version: '1.4.10',
            },
            {
                cve_id: 'CVE-2018-7648',
                cvss_score_v3: 9.8,
                package: 'libopenjp2-7',
                severity: 'Low',
                version: '2.3.0-2+deb10u2',
            },
            {
                cve_id: 'CVE-2023-34152',
                cvss_score_v3: 9.8,
                package: 'libmagickcore-6.q16-6',
                severity: 'Low',
                version: '8:6.9.10.23+dfsg-2.1+deb10u1',
            },
            {
                cve_id: 'CVE-2020-35527',
                cvss_score_v3: 9.8,
                package: 'libsqlite3-0',
                severity: 'Critical',
                version: '3.27.2-3+deb10u1',
            },
        ],
        fixable_cnt: 3937,
        high_cnt: 2191,
        low_cnt: 2385,
        medium_cnt: 2132,
        scanned_cnt: 41,
        total_artifact: 41,
        total_vuls: 7115,
        unknown_cnt: 84,
    };

    const fakedSecurityhubService = {
        getSecuritySummary() {
            return of(mockedSummary).pipe(delay(0));
        },
    };

    beforeEach(async () => {
        await TestBed.configureTestingModule({
            schemas: [NO_ERRORS_SCHEMA],
            imports: [SharedTestingModule],
            declarations: [VulnerabilitySummaryComponent],
            providers: [
                {
                    provide: SecurityhubService,
                    useValue: fakedSecurityhubService,
                },
            ],
        }).compileComponents();

        fixture = TestBed.createComponent(VulnerabilitySummaryComponent);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    it('should create', () => {
        expect(component).toBeTruthy();
    });

    it('should create', async () => {
        fixture.detectChanges();
        await fixture.whenStable();
        fixture.detectChanges();
        const cards = fixture.nativeElement.querySelectorAll('.card');
        expect(cards.length).toEqual(3);
    });
});
