// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import { ComponentFixture, TestBed } from '@angular/core/testing';
import { VulnerabilityFilterComponent } from './vulnerability-filter.component';
import { OptionType } from '../security-hub.interface';
import { SharedTestingModule } from '../../../../../shared/shared.module';
import { NO_ERRORS_SCHEMA } from '@angular/core';

describe('VulnerabilityFilterComponent', () => {
    let component: VulnerabilityFilterComponent;
    let fixture: ComponentFixture<VulnerabilityFilterComponent>;

    beforeEach(async () => {
        await TestBed.configureTestingModule({
            schemas: [NO_ERRORS_SCHEMA],
            imports: [SharedTestingModule],
            declarations: [VulnerabilityFilterComponent],
        }).compileComponents();

        fixture = TestBed.createComponent(VulnerabilityFilterComponent);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    it('should create', () => {
        expect(component).toBeTruthy();
    });

    it('"All" is selected by default', () => {
        fixture.detectChanges();
        const select: HTMLSelectElement =
            fixture.nativeElement.querySelector('select');
        expect(select.value).toEqual(OptionType.ALL);
    });
});
