package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAsrConfig invokes the voicenavigator.ModifyAsrConfig API synchronously
func (client *Client) ModifyAsrConfig(request *ModifyAsrConfigRequest) (response *ModifyAsrConfigResponse, err error) {
	response = CreateModifyAsrConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAsrConfigWithChan invokes the voicenavigator.ModifyAsrConfig API asynchronously
func (client *Client) ModifyAsrConfigWithChan(request *ModifyAsrConfigRequest) (<-chan *ModifyAsrConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyAsrConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAsrConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAsrConfigWithCallback invokes the voicenavigator.ModifyAsrConfig API asynchronously
func (client *Client) ModifyAsrConfigWithCallback(request *ModifyAsrConfigRequest, callback func(response *ModifyAsrConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAsrConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyAsrConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAsrConfigRequest is the request struct for api ModifyAsrConfig
type ModifyAsrConfigRequest struct {
	*requests.RpcRequest
	AsrVocabularyId      string           `position:"Query" name:"AsrVocabularyId"`
	AsrClassVocabularyId string           `position:"Query" name:"AsrClassVocabularyId"`
	EntryId              string           `position:"Query" name:"EntryId"`
	AsrCustomizationId   string           `position:"Query" name:"AsrCustomizationId"`
	ConfigLevel          requests.Integer `position:"Query" name:"ConfigLevel"`
	AsrAcousticModelId   string           `position:"Query" name:"AsrAcousticModelId"`
}

// ModifyAsrConfigResponse is the response struct for api ModifyAsrConfig
type ModifyAsrConfigResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateModifyAsrConfigRequest creates a request to invoke ModifyAsrConfig API
func CreateModifyAsrConfigRequest() (request *ModifyAsrConfigRequest) {
	request = &ModifyAsrConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ModifyAsrConfig", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAsrConfigResponse creates a response to parse from ModifyAsrConfig response
func CreateModifyAsrConfigResponse() (response *ModifyAsrConfigResponse) {
	response = &ModifyAsrConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
