package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCrossdomainContent invokes the vod.SetCrossdomainContent API synchronously
func (client *Client) SetCrossdomainContent(request *SetCrossdomainContentRequest) (response *SetCrossdomainContentResponse, err error) {
	response = CreateSetCrossdomainContentResponse()
	err = client.DoAction(request, response)
	return
}

// SetCrossdomainContentWithChan invokes the vod.SetCrossdomainContent API asynchronously
func (client *Client) SetCrossdomainContentWithChan(request *SetCrossdomainContentRequest) (<-chan *SetCrossdomainContentResponse, <-chan error) {
	responseChan := make(chan *SetCrossdomainContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCrossdomainContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCrossdomainContentWithCallback invokes the vod.SetCrossdomainContent API asynchronously
func (client *Client) SetCrossdomainContentWithCallback(request *SetCrossdomainContentRequest, callback func(response *SetCrossdomainContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCrossdomainContentResponse
		var err error
		defer close(result)
		response, err = client.SetCrossdomainContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCrossdomainContentRequest is the request struct for api SetCrossdomainContent
type SetCrossdomainContentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	ResourceRealOwnerId  string `position:"Query" name:"ResourceRealOwnerId"`
	Content              string `position:"Query" name:"Content"`
	StorageLocation      string `position:"Query" name:"StorageLocation"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
}

// SetCrossdomainContentResponse is the response struct for api SetCrossdomainContent
type SetCrossdomainContentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetCrossdomainContentRequest creates a request to invoke SetCrossdomainContent API
func CreateSetCrossdomainContentRequest() (request *SetCrossdomainContentRequest) {
	request = &SetCrossdomainContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SetCrossdomainContent", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetCrossdomainContentResponse creates a response to parse from SetCrossdomainContent response
func CreateSetCrossdomainContentResponse() (response *SetCrossdomainContentResponse) {
	response = &SetCrossdomainContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
