package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainRealTimeBpsData invokes the vod.DescribeVodDomainRealTimeBpsData API synchronously
func (client *Client) DescribeVodDomainRealTimeBpsData(request *DescribeVodDomainRealTimeBpsDataRequest) (response *DescribeVodDomainRealTimeBpsDataResponse, err error) {
	response = CreateDescribeVodDomainRealTimeBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainRealTimeBpsDataWithChan invokes the vod.DescribeVodDomainRealTimeBpsData API asynchronously
func (client *Client) DescribeVodDomainRealTimeBpsDataWithChan(request *DescribeVodDomainRealTimeBpsDataRequest) (<-chan *DescribeVodDomainRealTimeBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainRealTimeBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainRealTimeBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainRealTimeBpsDataWithCallback invokes the vod.DescribeVodDomainRealTimeBpsData API asynchronously
func (client *Client) DescribeVodDomainRealTimeBpsDataWithCallback(request *DescribeVodDomainRealTimeBpsDataRequest, callback func(response *DescribeVodDomainRealTimeBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainRealTimeBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainRealTimeBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainRealTimeBpsDataRequest is the request struct for api DescribeVodDomainRealTimeBpsData
type DescribeVodDomainRealTimeBpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodDomainRealTimeBpsDataResponse is the response struct for api DescribeVodDomainRealTimeBpsData
type DescribeVodDomainRealTimeBpsDataResponse struct {
	*responses.BaseResponse
	RequestId string                                 `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeVodDomainRealTimeBpsData `json:"Data" xml:"Data"`
}

// CreateDescribeVodDomainRealTimeBpsDataRequest creates a request to invoke DescribeVodDomainRealTimeBpsData API
func CreateDescribeVodDomainRealTimeBpsDataRequest() (request *DescribeVodDomainRealTimeBpsDataRequest) {
	request = &DescribeVodDomainRealTimeBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainRealTimeBpsData", "vod", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeVodDomainRealTimeBpsDataResponse creates a response to parse from DescribeVodDomainRealTimeBpsData response
func CreateDescribeVodDomainRealTimeBpsDataResponse() (response *DescribeVodDomainRealTimeBpsDataResponse) {
	response = &DescribeVodDomainRealTimeBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
