package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddEditingProjectMaterials invokes the vod.AddEditingProjectMaterials API synchronously
func (client *Client) AddEditingProjectMaterials(request *AddEditingProjectMaterialsRequest) (response *AddEditingProjectMaterialsResponse, err error) {
	response = CreateAddEditingProjectMaterialsResponse()
	err = client.DoAction(request, response)
	return
}

// AddEditingProjectMaterialsWithChan invokes the vod.AddEditingProjectMaterials API asynchronously
func (client *Client) AddEditingProjectMaterialsWithChan(request *AddEditingProjectMaterialsRequest) (<-chan *AddEditingProjectMaterialsResponse, <-chan error) {
	responseChan := make(chan *AddEditingProjectMaterialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddEditingProjectMaterials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddEditingProjectMaterialsWithCallback invokes the vod.AddEditingProjectMaterials API asynchronously
func (client *Client) AddEditingProjectMaterialsWithCallback(request *AddEditingProjectMaterialsRequest, callback func(response *AddEditingProjectMaterialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddEditingProjectMaterialsResponse
		var err error
		defer close(result)
		response, err = client.AddEditingProjectMaterials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddEditingProjectMaterialsRequest is the request struct for api AddEditingProjectMaterials
type AddEditingProjectMaterialsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	MaterialType         string `position:"Query" name:"MaterialType"`
	ProjectId            string `position:"Query" name:"ProjectId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	MaterialIds          string `position:"Query" name:"MaterialIds"`
}

// AddEditingProjectMaterialsResponse is the response struct for api AddEditingProjectMaterials
type AddEditingProjectMaterialsResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	MaterialList []Material `json:"MaterialList" xml:"MaterialList"`
}

// CreateAddEditingProjectMaterialsRequest creates a request to invoke AddEditingProjectMaterials API
func CreateAddEditingProjectMaterialsRequest() (request *AddEditingProjectMaterialsRequest) {
	request = &AddEditingProjectMaterialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "AddEditingProjectMaterials", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddEditingProjectMaterialsResponse creates a response to parse from AddEditingProjectMaterials response
func CreateAddEditingProjectMaterialsResponse() (response *AddEditingProjectMaterialsResponse) {
	response = &AddEditingProjectMaterialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
