package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUises invokes the uis.DescribeUises API synchronously
// api document: https://help.aliyun.com/api/uis/describeuises.html
func (client *Client) DescribeUises(request *DescribeUisesRequest) (response *DescribeUisesResponse, err error) {
	response = CreateDescribeUisesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUisesWithChan invokes the uis.DescribeUises API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuises.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisesWithChan(request *DescribeUisesRequest) (<-chan *DescribeUisesResponse, <-chan error) {
	responseChan := make(chan *DescribeUisesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUises(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUisesWithCallback invokes the uis.DescribeUises API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuises.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisesWithCallback(request *DescribeUisesRequest, callback func(response *DescribeUisesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUisesResponse
		var err error
		defer close(result)
		response, err = client.DescribeUises(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUisesRequest is the request struct for api DescribeUises
type DescribeUisesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UisId                string           `position:"Query" name:"UisId"`
	Name                 string           `position:"Query" name:"Name"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeUisesResponse is the response struct for api DescribeUises
type DescribeUisesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	Uises      Uises  `json:"Uises" xml:"Uises"`
}

// CreateDescribeUisesRequest creates a request to invoke DescribeUises API
func CreateDescribeUisesRequest() (request *DescribeUisesRequest) {
	request = &DescribeUisesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeUises", "uis", "openAPI")
	return
}

// CreateDescribeUisesResponse creates a response to parse from DescribeUises response
func CreateDescribeUisesResponse() (response *DescribeUisesResponse) {
	response = &DescribeUisesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
