package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTradeMarkApplications invokes the trademark.QueryTradeMarkApplications API synchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkapplications.html
func (client *Client) QueryTradeMarkApplications(request *QueryTradeMarkApplicationsRequest) (response *QueryTradeMarkApplicationsResponse, err error) {
	response = CreateQueryTradeMarkApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTradeMarkApplicationsWithChan invokes the trademark.QueryTradeMarkApplications API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkapplications.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeMarkApplicationsWithChan(request *QueryTradeMarkApplicationsRequest) (<-chan *QueryTradeMarkApplicationsResponse, <-chan error) {
	responseChan := make(chan *QueryTradeMarkApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTradeMarkApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTradeMarkApplicationsWithCallback invokes the trademark.QueryTradeMarkApplications API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkapplications.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeMarkApplicationsWithCallback(request *QueryTradeMarkApplicationsRequest, callback func(response *QueryTradeMarkApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTradeMarkApplicationsResponse
		var err error
		defer close(result)
		response, err = client.QueryTradeMarkApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTradeMarkApplicationsRequest is the request struct for api QueryTradeMarkApplications
type QueryTradeMarkApplicationsRequest struct {
	*requests.RpcRequest
	TmName           string           `position:"Query" name:"TmName"`
	MaterialName     string           `position:"Query" name:"MaterialName"`
	OrderId          string           `position:"Query" name:"OrderId"`
	SupplementStatus requests.Integer `position:"Query" name:"SupplementStatus"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	BizId            string           `position:"Query" name:"BizId"`
	TmNumber         string           `position:"Query" name:"TmNumber"`
	SortOrder        string           `position:"Query" name:"SortOrder"`
	PageNum          requests.Integer `position:"Query" name:"PageNum"`
	Type             string           `position:"Query" name:"Type"`
	Status           requests.Integer `position:"Query" name:"Status"`
}

// QueryTradeMarkApplicationsResponse is the response struct for api QueryTradeMarkApplications
type QueryTradeMarkApplicationsResponse struct {
	*responses.BaseResponse
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                              `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                              `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                              `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                              `json:"TotalPageNum" xml:"TotalPageNum"`
	Data           DataInQueryTradeMarkApplications `json:"Data" xml:"Data"`
}

// CreateQueryTradeMarkApplicationsRequest creates a request to invoke QueryTradeMarkApplications API
func CreateQueryTradeMarkApplicationsRequest() (request *QueryTradeMarkApplicationsRequest) {
	request = &QueryTradeMarkApplicationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryTradeMarkApplications", "trademark", "openAPI")
	return
}

// CreateQueryTradeMarkApplicationsResponse creates a response to parse from QueryTradeMarkApplications response
func CreateQueryTradeMarkApplicationsResponse() (response *QueryTradeMarkApplicationsResponse) {
	response = &QueryTradeMarkApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
