package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCommandAttribute invokes the swas_open.UpdateCommandAttribute API synchronously
func (client *Client) UpdateCommandAttribute(request *UpdateCommandAttributeRequest) (response *UpdateCommandAttributeResponse, err error) {
	response = CreateUpdateCommandAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCommandAttributeWithChan invokes the swas_open.UpdateCommandAttribute API asynchronously
func (client *Client) UpdateCommandAttributeWithChan(request *UpdateCommandAttributeRequest) (<-chan *UpdateCommandAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateCommandAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCommandAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCommandAttributeWithCallback invokes the swas_open.UpdateCommandAttribute API asynchronously
func (client *Client) UpdateCommandAttributeWithCallback(request *UpdateCommandAttributeRequest, callback func(response *UpdateCommandAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCommandAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateCommandAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCommandAttributeRequest is the request struct for api UpdateCommandAttribute
type UpdateCommandAttributeRequest struct {
	*requests.RpcRequest
	WorkingDir  string           `position:"Query" name:"WorkingDir"`
	Description string           `position:"Query" name:"Description"`
	CommandId   string           `position:"Query" name:"CommandId"`
	Timeout     requests.Integer `position:"Query" name:"Timeout"`
	Name        string           `position:"Query" name:"Name"`
}

// UpdateCommandAttributeResponse is the response struct for api UpdateCommandAttribute
type UpdateCommandAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCommandAttributeRequest creates a request to invoke UpdateCommandAttribute API
func CreateUpdateCommandAttributeRequest() (request *UpdateCommandAttributeRequest) {
	request = &UpdateCommandAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "UpdateCommandAttribute", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCommandAttributeResponse creates a response to parse from UpdateCommandAttribute response
func CreateUpdateCommandAttributeResponse() (response *UpdateCommandAttributeResponse) {
	response = &UpdateCommandAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
