package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstances invokes the swas_open.CreateInstances API synchronously
func (client *Client) CreateInstances(request *CreateInstancesRequest) (response *CreateInstancesResponse, err error) {
	response = CreateCreateInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstancesWithChan invokes the swas_open.CreateInstances API asynchronously
func (client *Client) CreateInstancesWithChan(request *CreateInstancesRequest) (<-chan *CreateInstancesResponse, <-chan error) {
	responseChan := make(chan *CreateInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstancesWithCallback invokes the swas_open.CreateInstances API asynchronously
func (client *Client) CreateInstancesWithCallback(request *CreateInstancesRequest, callback func(response *CreateInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstancesResponse
		var err error
		defer close(result)
		response, err = client.CreateInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstancesRequest is the request struct for api CreateInstances
type CreateInstancesRequest struct {
	*requests.RpcRequest
	ImageId         string           `position:"Query" name:"ImageId"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	AutoRenewPeriod requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period          requests.Integer `position:"Query" name:"Period"`
	Amount          requests.Integer `position:"Query" name:"Amount"`
	AutoRenew       requests.Boolean `position:"Query" name:"AutoRenew"`
	DataDiskSize    requests.Integer `position:"Query" name:"DataDiskSize"`
	PlanId          string           `position:"Query" name:"PlanId"`
	ChargeType      string           `position:"Query" name:"ChargeType"`
}

// CreateInstancesResponse is the response struct for api CreateInstances
type CreateInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	InstanceIds []string `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateInstancesRequest creates a request to invoke CreateInstances API
func CreateCreateInstancesRequest() (request *CreateInstancesRequest) {
	request = &CreateInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "CreateInstances", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateInstancesResponse creates a response to parse from CreateInstances response
func CreateCreateInstancesResponse() (response *CreateInstancesResponse) {
	response = &CreateInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
