package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListContacts invokes the subscription.ListContacts API synchronously
// api document: https://help.aliyun.com/api/subscription/listcontacts.html
func (client *Client) ListContacts(request *ListContactsRequest) (response *ListContactsResponse, err error) {
	response = CreateListContactsResponse()
	err = client.DoAction(request, response)
	return
}

// ListContactsWithChan invokes the subscription.ListContacts API asynchronously
// api document: https://help.aliyun.com/api/subscription/listcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListContactsWithChan(request *ListContactsRequest) (<-chan *ListContactsResponse, <-chan error) {
	responseChan := make(chan *ListContactsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListContacts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListContactsWithCallback invokes the subscription.ListContacts API asynchronously
// api document: https://help.aliyun.com/api/subscription/listcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListContactsWithCallback(request *ListContactsRequest, callback func(response *ListContactsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListContactsResponse
		var err error
		defer close(result)
		response, err = client.ListContacts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListContactsRequest is the request struct for api ListContacts
type ListContactsRequest struct {
	*requests.RpcRequest
	ContactId  requests.Integer `position:"Query" name:"ContactId"`
	Locale     string           `position:"Query" name:"Locale"`
	Filter     string           `position:"Query" name:"Filter"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ListContactsResponse is the response struct for api ListContacts
type ListContactsResponse struct {
	*responses.BaseResponse
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	Message    string    `json:"Message" xml:"Message"`
	NextToken  int       `json:"NextToken" xml:"NextToken"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Code       string    `json:"Code" xml:"Code"`
	Success    bool      `json:"Success" xml:"Success"`
	Contacts   []Contact `json:"Contacts" xml:"Contacts"`
}

// CreateListContactsRequest creates a request to invoke ListContacts API
func CreateListContactsRequest() (request *ListContactsRequest) {
	request = &ListContactsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "ListContacts", "", "")
	return
}

// CreateListContactsResponse creates a response to parse from ListContacts response
func CreateListContactsResponse() (response *ListContactsResponse) {
	response = &ListContactsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
