package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopBECluster invokes the selectdb.StopBECluster API synchronously
func (client *Client) StopBECluster(request *StopBEClusterRequest) (response *StopBEClusterResponse, err error) {
	response = CreateStopBEClusterResponse()
	err = client.DoAction(request, response)
	return
}

// StopBEClusterWithChan invokes the selectdb.StopBECluster API asynchronously
func (client *Client) StopBEClusterWithChan(request *StopBEClusterRequest) (<-chan *StopBEClusterResponse, <-chan error) {
	responseChan := make(chan *StopBEClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopBECluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopBEClusterWithCallback invokes the selectdb.StopBECluster API asynchronously
func (client *Client) StopBEClusterWithCallback(request *StopBEClusterRequest, callback func(response *StopBEClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopBEClusterResponse
		var err error
		defer close(result)
		response, err = client.StopBECluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopBEClusterRequest is the request struct for api StopBECluster
type StopBEClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBClusterId     string           `position:"Query" name:"DBClusterId"`
	DBInstanceId    string           `position:"Query" name:"DBInstanceId"`
}

// StopBEClusterResponse is the response struct for api StopBECluster
type StopBEClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopBEClusterRequest creates a request to invoke StopBECluster API
func CreateStopBEClusterRequest() (request *StopBEClusterRequest) {
	request = &StopBEClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "StopBECluster", "", "")
	request.Method = requests.POST
	return
}

// CreateStopBEClusterResponse creates a response to parse from StopBECluster response
func CreateStopBEClusterResponse() (response *StopBEClusterResponse) {
	response = &StopBEClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
