package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySecurityIPList invokes the selectdb.ModifySecurityIPList API synchronously
func (client *Client) ModifySecurityIPList(request *ModifySecurityIPListRequest) (response *ModifySecurityIPListResponse, err error) {
	response = CreateModifySecurityIPListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySecurityIPListWithChan invokes the selectdb.ModifySecurityIPList API asynchronously
func (client *Client) ModifySecurityIPListWithChan(request *ModifySecurityIPListRequest) (<-chan *ModifySecurityIPListResponse, <-chan error) {
	responseChan := make(chan *ModifySecurityIPListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySecurityIPList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySecurityIPListWithCallback invokes the selectdb.ModifySecurityIPList API asynchronously
func (client *Client) ModifySecurityIPListWithCallback(request *ModifySecurityIPListRequest, callback func(response *ModifySecurityIPListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySecurityIPListResponse
		var err error
		defer close(result)
		response, err = client.ModifySecurityIPList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySecurityIPListRequest is the request struct for api ModifySecurityIPList
type ModifySecurityIPListRequest struct {
	*requests.RpcRequest
	ModifyMode      string           `position:"Query" name:"ModifyMode"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	GroupName       string           `position:"Query" name:"GroupName"`
	SecurityIPList  string           `position:"Query" name:"SecurityIPList"`
	DBInstanceId    string           `position:"Query" name:"DBInstanceId"`
}

// ModifySecurityIPListResponse is the response struct for api ModifySecurityIPList
type ModifySecurityIPListResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	GroupName        string `json:"GroupName" xml:"GroupName"`
	SecurityIPType   string `json:"SecurityIPType" xml:"SecurityIPType"`
	GroupTag         string `json:"GroupTag" xml:"GroupTag"`
	TaskId           int64  `json:"TaskId" xml:"TaskId"`
	SecurityIPList   string `json:"SecurityIPList" xml:"SecurityIPList"`
	WhitelistNetType string `json:"WhitelistNetType" xml:"WhitelistNetType"`
	DBInstanceName   string `json:"DBInstanceName" xml:"DBInstanceName"`
}

// CreateModifySecurityIPListRequest creates a request to invoke ModifySecurityIPList API
func CreateModifySecurityIPListRequest() (request *ModifySecurityIPListRequest) {
	request = &ModifySecurityIPListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "ModifySecurityIPList", "", "")
	request.Method = requests.POST
	return
}

// CreateModifySecurityIPListResponse creates a response to parse from ModifySecurityIPList response
func CreateModifySecurityIPListResponse() (response *ModifySecurityIPListResponse) {
	response = &ModifySecurityIPListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
