package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticRules invokes the selectdb.DescribeElasticRules API synchronously
func (client *Client) DescribeElasticRules(request *DescribeElasticRulesRequest) (response *DescribeElasticRulesResponse, err error) {
	response = CreateDescribeElasticRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticRulesWithChan invokes the selectdb.DescribeElasticRules API asynchronously
func (client *Client) DescribeElasticRulesWithChan(request *DescribeElasticRulesRequest) (<-chan *DescribeElasticRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticRulesWithCallback invokes the selectdb.DescribeElasticRules API asynchronously
func (client *Client) DescribeElasticRulesWithCallback(request *DescribeElasticRulesRequest, callback func(response *DescribeElasticRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticRulesRequest is the request struct for api DescribeElasticRules
type DescribeElasticRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Product         string           `position:"Query" name:"Product"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	DbInstanceId    string           `position:"Query" name:"DbInstanceId"`
}

// DescribeElasticRulesResponse is the response struct for api DescribeElasticRules
type DescribeElasticRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeElasticRulesRequest creates a request to invoke DescribeElasticRules API
func CreateDescribeElasticRulesRequest() (request *DescribeElasticRulesRequest) {
	request = &DescribeElasticRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "DescribeElasticRules", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeElasticRulesResponse creates a response to parse from DescribeElasticRules response
func CreateDescribeElasticRulesResponse() (response *DescribeElasticRulesResponse) {
	response = &DescribeElasticRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
