package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteElasticRule invokes the selectdb.DeleteElasticRule API synchronously
func (client *Client) DeleteElasticRule(request *DeleteElasticRuleRequest) (response *DeleteElasticRuleResponse, err error) {
	response = CreateDeleteElasticRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteElasticRuleWithChan invokes the selectdb.DeleteElasticRule API asynchronously
func (client *Client) DeleteElasticRuleWithChan(request *DeleteElasticRuleRequest) (<-chan *DeleteElasticRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteElasticRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteElasticRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteElasticRuleWithCallback invokes the selectdb.DeleteElasticRule API asynchronously
func (client *Client) DeleteElasticRuleWithCallback(request *DeleteElasticRuleRequest, callback func(response *DeleteElasticRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteElasticRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteElasticRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteElasticRuleRequest is the request struct for api DeleteElasticRule
type DeleteElasticRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Product         string           `position:"Query" name:"Product"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	DbInstanceId    string           `position:"Query" name:"DbInstanceId"`
	RuleId          requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteElasticRuleResponse is the response struct for api DeleteElasticRule
type DeleteElasticRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteElasticRuleRequest creates a request to invoke DeleteElasticRule API
func CreateDeleteElasticRuleRequest() (request *DeleteElasticRuleRequest) {
	request = &DeleteElasticRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "DeleteElasticRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteElasticRuleResponse creates a response to parse from DeleteElasticRule response
func CreateDeleteElasticRuleResponse() (response *DeleteElasticRuleResponse) {
	response = &DeleteElasticRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
