package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateStopJobExecution invokes the schedulerx3.OperateStopJobExecution API synchronously
func (client *Client) OperateStopJobExecution(request *OperateStopJobExecutionRequest) (response *OperateStopJobExecutionResponse, err error) {
	response = CreateOperateStopJobExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// OperateStopJobExecutionWithChan invokes the schedulerx3.OperateStopJobExecution API asynchronously
func (client *Client) OperateStopJobExecutionWithChan(request *OperateStopJobExecutionRequest) (<-chan *OperateStopJobExecutionResponse, <-chan error) {
	responseChan := make(chan *OperateStopJobExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateStopJobExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateStopJobExecutionWithCallback invokes the schedulerx3.OperateStopJobExecution API asynchronously
func (client *Client) OperateStopJobExecutionWithCallback(request *OperateStopJobExecutionRequest, callback func(response *OperateStopJobExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateStopJobExecutionResponse
		var err error
		defer close(result)
		response, err = client.OperateStopJobExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateStopJobExecutionRequest is the request struct for api OperateStopJobExecution
type OperateStopJobExecutionRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	JobId          requests.Integer `position:"Query" name:"JobId"`
	AppName        string           `position:"Query" name:"AppName"`
	JobExecutionId string           `position:"Query" name:"JobExecutionId"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	TaskList       *[]string        `position:"Query" name:"TaskList"  type:"Json"`
}

// OperateStopJobExecutionResponse is the response struct for api OperateStopJobExecution
type OperateStopJobExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateOperateStopJobExecutionRequest creates a request to invoke OperateStopJobExecution API
func CreateOperateStopJobExecutionRequest() (request *OperateStopJobExecutionRequest) {
	request = &OperateStopJobExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateStopJobExecution", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateStopJobExecutionResponse creates a response to parse from OperateStopJobExecution response
func CreateOperateStopJobExecutionResponse() (response *OperateStopJobExecutionResponse) {
	response = &OperateStopJobExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
