package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobExecutionProgress invokes the schedulerx3.GetJobExecutionProgress API synchronously
func (client *Client) GetJobExecutionProgress(request *GetJobExecutionProgressRequest) (response *GetJobExecutionProgressResponse, err error) {
	response = CreateGetJobExecutionProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobExecutionProgressWithChan invokes the schedulerx3.GetJobExecutionProgress API asynchronously
func (client *Client) GetJobExecutionProgressWithChan(request *GetJobExecutionProgressRequest) (<-chan *GetJobExecutionProgressResponse, <-chan error) {
	responseChan := make(chan *GetJobExecutionProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobExecutionProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobExecutionProgressWithCallback invokes the schedulerx3.GetJobExecutionProgress API asynchronously
func (client *Client) GetJobExecutionProgressWithCallback(request *GetJobExecutionProgressRequest, callback func(response *GetJobExecutionProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobExecutionProgressResponse
		var err error
		defer close(result)
		response, err = client.GetJobExecutionProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobExecutionProgressRequest is the request struct for api GetJobExecutionProgress
type GetJobExecutionProgressRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	AppName        string `position:"Query" name:"AppName"`
	JobExecutionId string `position:"Query" name:"JobExecutionId"`
}

// GetJobExecutionProgressResponse is the response struct for api GetJobExecutionProgress
type GetJobExecutionProgressResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetJobExecutionProgressRequest creates a request to invoke GetJobExecutionProgress API
func CreateGetJobExecutionProgressRequest() (request *GetJobExecutionProgressRequest) {
	request = &GetJobExecutionProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "GetJobExecutionProgress", "", "")
	request.Method = requests.GET
	return
}

// CreateGetJobExecutionProgressResponse creates a response to parse from GetJobExecutionProgress response
func CreateGetJobExecutionProgressResponse() (response *GetJobExecutionProgressResponse) {
	response = &GetJobExecutionProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
