package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryGroupedSecurityEventMarkMissList invokes the sas.QueryGroupedSecurityEventMarkMissList API synchronously
func (client *Client) QueryGroupedSecurityEventMarkMissList(request *QueryGroupedSecurityEventMarkMissListRequest) (response *QueryGroupedSecurityEventMarkMissListResponse, err error) {
	response = CreateQueryGroupedSecurityEventMarkMissListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryGroupedSecurityEventMarkMissListWithChan invokes the sas.QueryGroupedSecurityEventMarkMissList API asynchronously
func (client *Client) QueryGroupedSecurityEventMarkMissListWithChan(request *QueryGroupedSecurityEventMarkMissListRequest) (<-chan *QueryGroupedSecurityEventMarkMissListResponse, <-chan error) {
	responseChan := make(chan *QueryGroupedSecurityEventMarkMissListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryGroupedSecurityEventMarkMissList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryGroupedSecurityEventMarkMissListWithCallback invokes the sas.QueryGroupedSecurityEventMarkMissList API asynchronously
func (client *Client) QueryGroupedSecurityEventMarkMissListWithCallback(request *QueryGroupedSecurityEventMarkMissListRequest, callback func(response *QueryGroupedSecurityEventMarkMissListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryGroupedSecurityEventMarkMissListResponse
		var err error
		defer close(result)
		response, err = client.QueryGroupedSecurityEventMarkMissList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryGroupedSecurityEventMarkMissListRequest is the request struct for api QueryGroupedSecurityEventMarkMissList
type QueryGroupedSecurityEventMarkMissListRequest struct {
	*requests.RpcRequest
	Remark      string           `position:"Body" name:"Remark"`
	EventName   string           `position:"Body" name:"EventName"`
	DisposalWay string           `position:"Query" name:"DisposalWay"`
	MaxId       requests.Integer `position:"Body" name:"MaxId"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	From        string           `position:"Body" name:"From"`
	Lang        string           `position:"Body" name:"Lang"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
}

// QueryGroupedSecurityEventMarkMissListResponse is the response struct for api QueryGroupedSecurityEventMarkMissList
type QueryGroupedSecurityEventMarkMissListResponse struct {
	*responses.BaseResponse
	Success        bool       `json:"Success" xml:"Success"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	TimeCost       int64      `json:"TimeCost" xml:"TimeCost"`
	PageInfo       PageInfo   `json:"PageInfo" xml:"PageInfo"`
	List           []ListItem `json:"List" xml:"List"`
}

// CreateQueryGroupedSecurityEventMarkMissListRequest creates a request to invoke QueryGroupedSecurityEventMarkMissList API
func CreateQueryGroupedSecurityEventMarkMissListRequest() (request *QueryGroupedSecurityEventMarkMissListRequest) {
	request = &QueryGroupedSecurityEventMarkMissListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "QueryGroupedSecurityEventMarkMissList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryGroupedSecurityEventMarkMissListResponse creates a response to parse from QueryGroupedSecurityEventMarkMissList response
func CreateQueryGroupedSecurityEventMarkMissListResponse() (response *QueryGroupedSecurityEventMarkMissListResponse) {
	response = &QueryGroupedSecurityEventMarkMissListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
