package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSimilarEventScenarios invokes the sas.DescribeSimilarEventScenarios API synchronously
func (client *Client) DescribeSimilarEventScenarios(request *DescribeSimilarEventScenariosRequest) (response *DescribeSimilarEventScenariosResponse, err error) {
	response = CreateDescribeSimilarEventScenariosResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSimilarEventScenariosWithChan invokes the sas.DescribeSimilarEventScenarios API asynchronously
func (client *Client) DescribeSimilarEventScenariosWithChan(request *DescribeSimilarEventScenariosRequest) (<-chan *DescribeSimilarEventScenariosResponse, <-chan error) {
	responseChan := make(chan *DescribeSimilarEventScenariosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSimilarEventScenarios(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSimilarEventScenariosWithCallback invokes the sas.DescribeSimilarEventScenarios API asynchronously
func (client *Client) DescribeSimilarEventScenariosWithCallback(request *DescribeSimilarEventScenariosRequest, callback func(response *DescribeSimilarEventScenariosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSimilarEventScenariosResponse
		var err error
		defer close(result)
		response, err = client.DescribeSimilarEventScenarios(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSimilarEventScenariosRequest is the request struct for api DescribeSimilarEventScenarios
type DescribeSimilarEventScenariosRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	SecurityEventId requests.Integer `position:"Query" name:"SecurityEventId"`
}

// DescribeSimilarEventScenariosResponse is the response struct for api DescribeSimilarEventScenarios
type DescribeSimilarEventScenariosResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Scenarios []Scenario `json:"Scenarios" xml:"Scenarios"`
}

// CreateDescribeSimilarEventScenariosRequest creates a request to invoke DescribeSimilarEventScenarios API
func CreateDescribeSimilarEventScenariosRequest() (request *DescribeSimilarEventScenariosRequest) {
	request = &DescribeSimilarEventScenariosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeSimilarEventScenarios", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSimilarEventScenariosResponse creates a response to parse from DescribeSimilarEventScenarios response
func CreateDescribeSimilarEventScenariosResponse() (response *DescribeSimilarEventScenariosResponse) {
	response = &DescribeSimilarEventScenariosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
