package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckResourcepackSlr invokes the retailadvqa_public.CheckResourcepackSlr API synchronously
func (client *Client) CheckResourcepackSlr(request *CheckResourcepackSlrRequest) (response *CheckResourcepackSlrResponse, err error) {
	response = CreateCheckResourcepackSlrResponse()
	err = client.DoAction(request, response)
	return
}

// CheckResourcepackSlrWithChan invokes the retailadvqa_public.CheckResourcepackSlr API asynchronously
func (client *Client) CheckResourcepackSlrWithChan(request *CheckResourcepackSlrRequest) (<-chan *CheckResourcepackSlrResponse, <-chan error) {
	responseChan := make(chan *CheckResourcepackSlrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckResourcepackSlr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckResourcepackSlrWithCallback invokes the retailadvqa_public.CheckResourcepackSlr API asynchronously
func (client *Client) CheckResourcepackSlrWithCallback(request *CheckResourcepackSlrRequest, callback func(response *CheckResourcepackSlrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckResourcepackSlrResponse
		var err error
		defer close(result)
		response, err = client.CheckResourcepackSlr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckResourcepackSlrRequest is the request struct for api CheckResourcepackSlr
type CheckResourcepackSlrRequest struct {
	*requests.RpcRequest
	AccessId string `position:"Query" name:"AccessId"`
}

// CheckResourcepackSlrResponse is the response struct for api CheckResourcepackSlr
type CheckResourcepackSlrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateCheckResourcepackSlrRequest creates a request to invoke CheckResourcepackSlr API
func CreateCheckResourcepackSlrRequest() (request *CheckResourcepackSlrRequest) {
	request = &CheckResourcepackSlrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "CheckResourcepackSlr", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckResourcepackSlrResponse creates a response to parse from CheckResourcepackSlr response
func CreateCheckResourcepackSlrResponse() (response *CheckResourcepackSlrResponse) {
	response = &CheckResourcepackSlrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
