package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceSharePermissions invokes the resourcesharing.ListResourceSharePermissions API synchronously
func (client *Client) ListResourceSharePermissions(request *ListResourceSharePermissionsRequest) (response *ListResourceSharePermissionsResponse, err error) {
	response = CreateListResourceSharePermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceSharePermissionsWithChan invokes the resourcesharing.ListResourceSharePermissions API asynchronously
func (client *Client) ListResourceSharePermissionsWithChan(request *ListResourceSharePermissionsRequest) (<-chan *ListResourceSharePermissionsResponse, <-chan error) {
	responseChan := make(chan *ListResourceSharePermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceSharePermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceSharePermissionsWithCallback invokes the resourcesharing.ListResourceSharePermissions API asynchronously
func (client *Client) ListResourceSharePermissionsWithCallback(request *ListResourceSharePermissionsRequest, callback func(response *ListResourceSharePermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceSharePermissionsResponse
		var err error
		defer close(result)
		response, err = client.ListResourceSharePermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceSharePermissionsRequest is the request struct for api ListResourceSharePermissions
type ListResourceSharePermissionsRequest struct {
	*requests.RpcRequest
	ResourceOwner   string           `position:"Query" name:"ResourceOwner"`
	NextToken       string           `position:"Query" name:"NextToken"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
	ResourceShareId string           `position:"Query" name:"ResourceShareId"`
}

// ListResourceSharePermissionsResponse is the response struct for api ListResourceSharePermissions
type ListResourceSharePermissionsResponse struct {
	*responses.BaseResponse
	NextToken   string       `json:"NextToken" xml:"NextToken"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	Permissions []Permission `json:"Permissions" xml:"Permissions"`
}

// CreateListResourceSharePermissionsRequest creates a request to invoke ListResourceSharePermissions API
func CreateListResourceSharePermissionsRequest() (request *ListResourceSharePermissionsRequest) {
	request = &ListResourceSharePermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListResourceSharePermissions", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourceSharePermissionsResponse creates a response to parse from ListResourceSharePermissions response
func CreateListResourceSharePermissionsResponse() (response *ListResourceSharePermissionsResponse) {
	response = &ListResourceSharePermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
