package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBProxy invokes the rds.ModifyDBProxy API synchronously
func (client *Client) ModifyDBProxy(request *ModifyDBProxyRequest) (response *ModifyDBProxyResponse, err error) {
	response = CreateModifyDBProxyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBProxyWithChan invokes the rds.ModifyDBProxy API asynchronously
func (client *Client) ModifyDBProxyWithChan(request *ModifyDBProxyRequest) (<-chan *ModifyDBProxyResponse, <-chan error) {
	responseChan := make(chan *ModifyDBProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBProxyWithCallback invokes the rds.ModifyDBProxy API asynchronously
func (client *Client) ModifyDBProxyWithCallback(request *ModifyDBProxyRequest, callback func(response *ModifyDBProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBProxyResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBProxyRequest is the request struct for api ModifyDBProxy
type ModifyDBProxyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId            string           `position:"Query" name:"ResourceGroupId"`
	AccountName                string           `position:"Query" name:"AccountName"`
	DBInstanceId               string           `position:"Query" name:"DBInstanceId"`
	PersistentConnectionStatus string           `position:"Query" name:"PersistentConnectionStatus"`
	ResourceOwnerAccount       string           `position:"Query" name:"ResourceOwnerAccount"`
	DBProxyEngineType          string           `position:"Query" name:"DBProxyEngineType"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
	DBProxyInstanceNum         string           `position:"Query" name:"DBProxyInstanceNum"`
	ConfigDBProxyService       string           `position:"Query" name:"ConfigDBProxyService"`
	VSwitchId                  string           `position:"Query" name:"VSwitchId"`
	AccountPassword            string           `position:"Query" name:"AccountPassword"`
	DBProxyInstanceType        string           `position:"Query" name:"DBProxyInstanceType"`
	VPCId                      string           `position:"Query" name:"VPCId"`
	InstanceNetworkType        string           `position:"Query" name:"InstanceNetworkType"`
}

// ModifyDBProxyResponse is the response struct for api ModifyDBProxy
type ModifyDBProxyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBProxyRequest creates a request to invoke ModifyDBProxy API
func CreateModifyDBProxyRequest() (request *ModifyDBProxyRequest) {
	request = &ModifyDBProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBProxy", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBProxyResponse creates a response to parse from ModifyDBProxy response
func CreateModifyDBProxyResponse() (response *ModifyDBProxyResponse) {
	response = &ModifyDBProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
