package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGadInstanceMember invokes the rds.CreateGadInstanceMember API synchronously
func (client *Client) CreateGadInstanceMember(request *CreateGadInstanceMemberRequest) (response *CreateGadInstanceMemberResponse, err error) {
	response = CreateCreateGadInstanceMemberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGadInstanceMemberWithChan invokes the rds.CreateGadInstanceMember API asynchronously
func (client *Client) CreateGadInstanceMemberWithChan(request *CreateGadInstanceMemberRequest) (<-chan *CreateGadInstanceMemberResponse, <-chan error) {
	responseChan := make(chan *CreateGadInstanceMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGadInstanceMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGadInstanceMemberWithCallback invokes the rds.CreateGadInstanceMember API asynchronously
func (client *Client) CreateGadInstanceMemberWithCallback(request *CreateGadInstanceMemberRequest, callback func(response *CreateGadInstanceMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGadInstanceMemberResponse
		var err error
		defer close(result)
		response, err = client.CreateGadInstanceMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGadInstanceMemberRequest is the request struct for api CreateGadInstanceMember
type CreateGadInstanceMemberRequest struct {
	*requests.RpcRequest
	CentralRdsDtsAdminAccount  string                             `position:"Query" name:"CentralRdsDtsAdminAccount"`
	CentralRegionId            string                             `position:"Query" name:"CentralRegionId"`
	GadInstanceId              string                             `position:"Query" name:"GadInstanceId"`
	UnitNode                   *[]CreateGadInstanceMemberUnitNode `position:"Query" name:"UnitNode"  type:"Repeated"`
	DBList                     string                             `position:"Query" name:"DBList"`
	CentralDBInstanceId        string                             `position:"Query" name:"CentralDBInstanceId"`
	CentralRdsDtsAdminPassword string                             `position:"Query" name:"CentralRdsDtsAdminPassword"`
}

// CreateGadInstanceMemberUnitNode is a repeated param struct in CreateGadInstanceMemberRequest
type CreateGadInstanceMemberUnitNode struct {
	DBInstanceStorage     string `name:"DBInstanceStorage"`
	ZoneIDSlave1          string `name:"ZoneIDSlave1"`
	ZoneIDSlave2          string `name:"ZoneIDSlave2"`
	EngineVersion         string `name:"EngineVersion"`
	DbInstanceClass       string `name:"DbInstanceClass"`
	VSwitchID             string `name:"VSwitchID"`
	SecurityIPList        string `name:"SecurityIPList"`
	RegionID              string `name:"RegionID"`
	Engine                string `name:"Engine"`
	DtsInstanceClass      string `name:"DtsInstanceClass"`
	VpcID                 string `name:"VpcID"`
	ZoneID                string `name:"ZoneID"`
	DBInstanceDescription string `name:"DBInstanceDescription"`
	DBInstanceStorageType string `name:"DBInstanceStorageType"`
	DtsConflict           string `name:"DtsConflict"`
}

// CreateGadInstanceMemberResponse is the response struct for api CreateGadInstanceMember
type CreateGadInstanceMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateGadInstanceMemberRequest creates a request to invoke CreateGadInstanceMember API
func CreateCreateGadInstanceMemberRequest() (request *CreateGadInstanceMemberRequest) {
	request = &CreateGadInstanceMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateGadInstanceMember", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGadInstanceMemberResponse creates a response to parse from CreateGadInstanceMember response
func CreateCreateGadInstanceMemberResponse() (response *CreateGadInstanceMemberResponse) {
	response = &CreateGadInstanceMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
